/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.mock.jndi;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.nuxeo.common.mock.jndi.MockContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockContextFactory
implements InitialContextFactory {
    private static final Map<String, Object> savedSystemProps = new HashMap<String, Object>();
    private static Hashtable<?, ?> delegateEnv;
    private static Context delegateContext;
    private static Context rootContext;

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        if (delegateContext == null && delegateEnv != null) {
            delegateContext = new InitialContext(delegateEnv);
        }
        if (rootContext == null) {
            rootContext = new MockContext(delegateContext);
        }
        return rootContext;
    }

    public static void setDelegateEnvironment(Hashtable<?, ?> env) {
        delegateEnv = env;
    }

    public static void setDelegateContext(Context ctx) {
        delegateContext = ctx;
    }

    public static void setAsInitial() {
        String key = "java.naming.factory.initial";
        savedSystemProps.put(key, System.getProperty(key));
        key = "java.naming.factory.url.pkgs";
        savedSystemProps.put(key, System.getProperty(key));
        System.setProperty("java.naming.factory.initial", MockContextFactory.class.getName());
        System.setProperty("java.naming.factory.url.pkgs", "org.nuxeo.common.mock.jndi");
    }

    public static void revertSetAsInitial() {
        for (Map.Entry<String, Object> entry : savedSystemProps.entrySet()) {
            MockContextFactory.restoreSystemProperty(entry.getKey(), (String)entry.getValue());
        }
        rootContext = null;
    }

    private static void restoreSystemProperty(String key, String value) {
        if (value != null) {
            System.setProperty(key, value);
        } else {
            System.getProperties().remove(key);
        }
    }
}

