/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.persistence;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.nuxeo.common.persistence.PersistentObject;
import org.nuxeo.common.persistence.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceManager {
    private final File dir;
    private final Map<String, PersistentObject> registry;

    public PersistenceManager(File dir) {
        this.dir = dir;
        this.registry = new Hashtable<String, PersistentObject>();
    }

    public File getStorageDirectory() {
        return this.dir;
    }

    public void registerPersistentObject(String id, PersistentObject object) {
        this.registry.put(id, object);
    }

    public void removePersistentObject(String id) {
        this.registry.remove(id);
    }

    public Collection<PersistentObject> getPersistentObjects() {
        return this.registry.values();
    }

    public void start() throws Exception {
        for (Map.Entry<String, PersistentObject> entry : this.registry.entrySet()) {
            String id = entry.getKey();
            PersistentObject obj = entry.getValue();
            this.restorePersistentObject(id, obj);
        }
    }

    public void stop() throws Exception {
        for (Map.Entry<String, PersistentObject> entry : this.registry.entrySet()) {
            String id = entry.getKey();
            PersistentObject obj = entry.getValue();
            this.storePersistentObject(id, obj);
        }
    }

    public File getPersistenceFile(String id) {
        return new File(this.dir, id + ".xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restorePersistentObject(String id, PersistentObject object) throws Exception {
        Reader reader = null;
        XMLMemento memento = null;
        try {
            File file = this.getPersistenceFile(id);
            if (!file.isFile()) {
                object.restoreState(null);
                return;
            }
            reader = new BufferedReader(new FileReader(file));
            memento = XMLMemento.createReadRoot(reader, this.dir.getAbsolutePath());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (memento != null) {
            object.restoreState(memento);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storePersistentObject(String id, PersistentObject object) throws Exception {
        XMLMemento memento = XMLMemento.createWriteRoot("persistence");
        object.saveState(memento);
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.getPersistenceFile(id)));
            memento.save(writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

