/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.nuxeo.common.utils.ZipEntryFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileIterator
implements Iterator<ZipEntry> {
    private final ZipFile zip;
    private final ZipEntryFilter filter;
    private final Enumeration<? extends ZipEntry> entries;
    private ZipEntry zentry;

    public ZipFileIterator(ZipFile zip, ZipEntryFilter filter) {
        this.zip = zip;
        this.filter = filter;
        this.entries = zip.entries();
        this.initNextEntry();
    }

    public ZipFileIterator(File file) throws IOException {
        this(new ZipFile(file), null);
    }

    public ZipFileIterator(File file, ZipEntryFilter filter) throws IOException {
        this(new ZipFile(file), filter);
    }

    public ZipFileIterator(ZipFile zip) {
        this(zip, null);
    }

    @Override
    public boolean hasNext() {
        return this.zentry != null;
    }

    @Override
    public ZipEntry next() {
        if (this.zentry == null) {
            throw new NoSuchElementException("There no more elements to iterate over");
        }
        ZipEntry ze = this.zentry;
        this.initNextEntry();
        return ze;
    }

    private void initNextEntry() {
        if (!this.entries.hasMoreElements()) {
            this.zentry = null;
            return;
        }
        this.zentry = this.entries.nextElement();
        if (this.filter != null) {
            while (!this.filter.accept(this.zentry.getName())) {
                if (this.entries.hasMoreElements()) {
                    this.zentry = this.entries.nextElement();
                    continue;
                }
                this.zentry = null;
                break;
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported by this iterator");
    }

    public ZipFile getZipFile() {
        return this.zip;
    }

    public void close() {
        if (this.zip != null) {
            try {
                this.zip.close();
            }
            catch (IOException ee) {
                ee.printStackTrace();
            }
        }
    }
}

