/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMHelper;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.XSetter;
import org.nuxeo.common.xmap.XValueFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XAnnotatedMember {
    protected final XSetter setter;
    protected Path path;
    protected boolean trim;
    protected Class type;
    protected XAnnotatedObject xao;
    protected XValueFactory valueFactory;
    private final XMap xmap;

    protected XAnnotatedMember(XMap xmap, XSetter setter) {
        this.xmap = xmap;
        this.setter = setter;
    }

    public XAnnotatedMember(XMap xmap, XSetter setter, XNode anno) {
        this.xmap = xmap;
        this.setter = setter;
        this.path = new Path(anno.value());
        this.trim = anno.trim();
        this.type = setter.getType();
        this.valueFactory = xmap.getValueFactory(this.type);
        this.xao = xmap.register(this.type);
    }

    protected void setValue(Object instance, Object value) throws Exception {
        try {
            this.setter.setValue(instance, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("%s, setter=%s, value=%s", e.getMessage(), this.setter, value), e);
        }
    }

    public void process(Context ctx, Element element) throws Exception {
        Object value = this.getValue(ctx, element);
        if (value != null) {
            this.setValue(ctx.getObject(), value);
        }
    }

    protected Object getValue(Context ctx, Element base) throws Exception {
        if (this.xao != null) {
            Element el = (Element)DOMHelper.getElementNode((Node)base, this.path);
            return el == null ? null : this.xao.newInstance(ctx, el);
        }
        if (this.type == Element.class) {
            return base;
        }
        String val = DOMHelper.getNodeValue(base, this.path);
        if (val != null) {
            if (this.trim) {
                val = val.trim();
            }
            return this.valueFactory.getValue(ctx, val);
        }
        return null;
    }
}

