/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ZipEntryFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipIterator
implements Iterator<ZipEntry> {
    private static final Log log = LogFactory.getLog(ZipIterator.class);
    private final ZipInputStream zin;
    private final ZipEntryFilter filter;
    private ZipEntry zentry;

    public ZipIterator(ZipInputStream zin, ZipEntryFilter filter) throws IOException {
        this.zin = zin;
        this.filter = filter;
        this.zentry = zin.getNextEntry();
    }

    public ZipIterator(URL url) throws IOException {
        this(url.openStream(), null);
    }

    public ZipIterator(URL url, ZipEntryFilter filter) throws IOException {
        this(url.openStream(), filter);
    }

    public ZipIterator(File file) throws IOException {
        this(new FileInputStream(file), null);
    }

    public ZipIterator(File file, ZipEntryFilter filter) throws IOException {
        this(new FileInputStream(file), filter);
    }

    public ZipIterator(InputStream in) throws IOException {
        this(new ZipInputStream(in), null);
    }

    public ZipIterator(InputStream in, ZipEntryFilter filter) throws IOException {
        this(new ZipInputStream(in), filter);
    }

    public ZipEntry getNextEntry() throws IOException {
        ZipEntry ze = this.zin.getNextEntry();
        if (ze == null) {
            return null;
        }
        if (this.filter != null) {
            while (!this.filter.accept(ze.getName())) {
                ze = this.zin.getNextEntry();
                if (ze != null) continue;
                return null;
            }
        }
        return ze;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported by this iterator");
    }

    @Override
    public boolean hasNext() {
        return this.zentry != null;
    }

    @Override
    public ZipEntry next() {
        ZipEntry oldEntry = this.zentry;
        try {
            this.zentry = this.getNextEntry();
        }
        catch (IOException e) {
            log.error((Object)e);
            this.zentry = null;
        }
        return oldEntry;
    }

    public InputStream getInputStream() {
        return this.zin;
    }

    public void close() {
        if (this.zin != null) {
            try {
                this.zin.close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }
}

