/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.Resource;
import org.w3c.dom.Node;

public abstract class XValueFactory {
    private static final Log log = LogFactory.getLog(XValueFactory.class);
    static final Map<Class, XValueFactory> defaultFactories = new Hashtable<Class, XValueFactory>();
    public static final XValueFactory STRING = new XValueFactory(){

        public Object deserialize(Context context, String value) {
            return value;
        }

        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory INTEGER = new XValueFactory(){

        public Object deserialize(Context context, String value) {
            return Integer.valueOf(value);
        }

        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory LONG = new XValueFactory(){

        public Object deserialize(Context context, String value) {
            return Long.valueOf(value);
        }

        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory DOUBLE = new XValueFactory(){

        public Object deserialize(Context context, String value) {
            return Double.valueOf(value);
        }

        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory FLOAT = new XValueFactory(){

        public Object deserialize(Context context, String value) {
            return Float.valueOf(value);
        }

        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory BOOLEAN = new XValueFactory(){

        public Object deserialize(Context context, String value) {
            return Boolean.valueOf(value);
        }

        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory DATE = new XValueFactory(){
        private final DateFormat df = DateFormat.getDateInstance();

        public Object deserialize(Context context, String value) {
            try {
                return this.df.parse(value);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String serialize(Context context, Object value) {
            Date date = (Date)value;
            return this.df.format(date);
        }
    };
    public static final XValueFactory FILE = new XValueFactory(){

        public Object deserialize(Context context, String value) {
            return new File(value);
        }

        public String serialize(Context context, Object value) {
            File file = (File)value;
            return file.getName();
        }
    };
    public static final XValueFactory URL = new XValueFactory(){

        public Object deserialize(Context context, String value) {
            try {
                return new URL(value);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };
    public static final XValueFactory CLASS = new XValueFactory(){

        public Object deserialize(Context context, String value) {
            try {
                return context.loadClass(value);
            }
            catch (Exception e) {
                log.error((Object)("Cannot load class: " + e));
                return null;
            }
        }

        public String serialize(Context context, Object value) {
            Class clazz = (Class)value;
            return clazz.getName();
        }
    };
    public static final XValueFactory RESOURCE = new XValueFactory(){

        public Object deserialize(Context context, String value) {
            try {
                return new Resource(context.getResource(value));
            }
            catch (Exception e) {
                log.error((Object)("Cannot load resource: " + e));
                return null;
            }
        }

        public String serialize(Context context, Object value) {
            return value.toString();
        }
    };

    public abstract Object deserialize(Context var1, String var2);

    public abstract String serialize(Context var1, Object var2);

    public final Object getElementValue(Context context, Node element, boolean trim) {
        String text = element.getTextContent();
        return this.deserialize(context, trim ? text.trim() : text);
    }

    public final Object getAttributeValue(Context context, Node element, String name) {
        Node at = element.getAttributes().getNamedItem(name);
        return at != null ? this.deserialize(context, at.getNodeValue()) : null;
    }

    public static void addFactory(Class klass, XValueFactory factory) {
        defaultFactories.put(klass, factory);
    }

    public static XValueFactory getFactory(Class type) {
        return defaultFactories.get(type);
    }

    public static Object getValue(Context context, Class klass, String value) {
        XValueFactory factory = defaultFactories.get(klass);
        if (factory == null) {
            return null;
        }
        return factory.deserialize(context, value);
    }

    static {
        XValueFactory.addFactory(String.class, STRING);
        XValueFactory.addFactory(Integer.class, INTEGER);
        XValueFactory.addFactory(Long.class, LONG);
        XValueFactory.addFactory(Double.class, DOUBLE);
        XValueFactory.addFactory(Date.class, DATE);
        XValueFactory.addFactory(Boolean.class, BOOLEAN);
        XValueFactory.addFactory(File.class, FILE);
        XValueFactory.addFactory(URL.class, URL);
        XValueFactory.addFactory(Integer.TYPE, INTEGER);
        XValueFactory.addFactory(Long.TYPE, LONG);
        XValueFactory.addFactory(Double.TYPE, DOUBLE);
        XValueFactory.addFactory(Float.TYPE, FLOAT);
        XValueFactory.addFactory(Boolean.TYPE, BOOLEAN);
        XValueFactory.addFactory(Class.class, CLASS);
        XValueFactory.addFactory(Resource.class, RESOURCE);
    }
}

