/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common;

import java.io.File;
import java.util.Map;
import java.util.Properties;

public class Environment {
    public static final String HOME_DIR = "org.nuxeo.app.home";
    public static final String WEB_DIR = "org.nuxeo.app.web";
    public static final String CONFIG_DIR = "org.nuxeo.app.config";
    public static final String DATA_DIR = "org.nuxeo.app.data";
    public static final String LOG_DIR = "org.nuxeo.app.log";
    public static final String BUNDLES_DIR = "nuxeo.osgi.app.bundles";
    public static final String BUNDLES = "nuxeo.osgi.bundles";
    private static Environment DEFAULT;
    protected final File home;
    protected File data;
    protected File log;
    protected File config;
    protected File web;
    protected File temp;
    protected final Properties properties;
    protected String[] args;
    protected boolean isAppServer;
    protected String hostAppName;
    protected String hostAppVersion;

    public static void setDefault(Environment env) {
        DEFAULT = env;
    }

    public static Environment getDefault() {
        return DEFAULT;
    }

    public Environment(File home) {
        this(home, null);
    }

    public Environment(File home, Properties properties) {
        this.home = home;
        this.properties = new Properties();
        if (properties != null) {
            this.loadProperties(properties);
        }
        this.properties.put(HOME_DIR, this.home.getAbsolutePath());
    }

    public File getHome() {
        return this.home;
    }

    public boolean isApplicationServer() {
        return this.isAppServer;
    }

    public void setIsApplicationServer(boolean isAppServer) {
        this.isAppServer = isAppServer;
    }

    public String getHostApplicationName() {
        return this.hostAppName;
    }

    public String getHostApplicationVersion() {
        return this.hostAppVersion;
    }

    public void setHostApplicationName(String name) {
        this.hostAppName = name;
    }

    public void setHostApplicationVersion(String version) {
        this.hostAppVersion = version;
    }

    public File getTemp() {
        if (this.temp == null) {
            this.temp = new File(this.home, "tmp");
        }
        return this.temp;
    }

    public void setTemp(File temp) {
        this.temp = temp;
    }

    public File getConfig() {
        if (this.config == null) {
            this.config = new File(this.home, "config");
        }
        return this.config;
    }

    public void setConfig(File config) {
        this.config = config;
    }

    public File getLog() {
        if (this.log == null) {
            this.log = new File(this.home, "log");
        }
        return this.log;
    }

    public void setLog(File log) {
        this.log = log;
    }

    public File getData() {
        if (this.data == null) {
            this.data = new File(this.home, "data");
        }
        return this.data;
    }

    public void setData(File data) {
        this.data = data;
    }

    public File getWeb() {
        if (this.web == null) {
            this.web = new File(this.home, "web");
        }
        return this.web;
    }

    public void setWeb(File web) {
        this.web = web;
    }

    public String[] getCommandLineArguments() {
        return this.args;
    }

    public void setCommandLineArguments(String[] args) {
        this.args = args;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.properties.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void loadProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        this.properties.put(HOME_DIR, this.home.getAbsolutePath());
    }
}

