/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.collections;

import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerList {
    public static final int EQUALITY = 0;
    public static final int IDENTITY = 1;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final int compareMode;
    private volatile Object[] listeners = EMPTY_ARRAY;
    private final Comparator<?> comparator;

    public ListenerList() {
        this(0, null);
    }

    public ListenerList(Comparator<?> comparator) {
        this(0, comparator);
    }

    public ListenerList(int mode, Comparator<?> comparator) {
        this.compareMode = mode;
        this.comparator = comparator;
    }

    public synchronized void add(Object listener) {
        int oldSize = this.listeners.length;
        for (int i = 0; i < oldSize; ++i) {
            if (!this.same(listener, this.listeners[i])) continue;
            return;
        }
        Object[] newListeners = new Object[oldSize + 1];
        System.arraycopy(this.listeners, 0, newListeners, 0, oldSize);
        newListeners[oldSize] = listener;
        if (this.comparator != null) {
            Arrays.sort(newListeners, this.comparator);
        }
        this.listeners = newListeners;
    }

    public Object[] getListeners() {
        return this.listeners;
    }

    public synchronized Object[] getListenersCopy() {
        Object[] tmp = new Object[this.listeners.length];
        System.arraycopy(this.listeners, 0, tmp, 0, this.listeners.length);
        return tmp;
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public synchronized void remove(Object listener) {
        int oldSize = this.listeners.length;
        for (int i = 0; i < oldSize; ++i) {
            if (!this.same(listener, this.listeners[i])) continue;
            if (oldSize == 1) {
                this.listeners = EMPTY_ARRAY;
            } else {
                Object[] newListeners = new Object[oldSize - 1];
                System.arraycopy(this.listeners, 0, newListeners, 0, i);
                System.arraycopy(this.listeners, i + 1, newListeners, i, oldSize - i - 1);
                this.listeners = newListeners;
            }
            return;
        }
    }

    private boolean same(Object listener1, Object listener2) {
        return this.compareMode == 1 ? listener1 == listener2 : listener1.equals(listener2);
    }

    public int size() {
        return this.listeners.length;
    }
}

