/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.util.ArrayList;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.PathFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathFilterSet
extends ArrayList<PathFilter>
implements PathFilter {
    private static final long serialVersionUID = -2967683005810353014L;
    private boolean isExclusive = true;

    public PathFilterSet() {
    }

    public PathFilterSet(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    @Override
    public boolean isExclusive() {
        return !this.isExclusive;
    }

    @Override
    public boolean accept(Path path) {
        int inclusive = 0;
        boolean defaultValue = false;
        for (PathFilter filter : this) {
            boolean ret = filter.accept(path);
            if (ret) {
                if (filter.isExclusive()) continue;
                ++inclusive;
                defaultValue = true;
                continue;
            }
            if (filter.isExclusive()) {
                return false;
            }
            ++inclusive;
        }
        return inclusive == 0 || defaultValue;
    }
}

