/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry<T> {
    private final String name;
    private final Map<String, T> registry;

    public Registry(String name) {
        this.name = name;
        this.registry = new HashMap<String, T>();
    }

    public String getName() {
        return this.name;
    }

    public void register(String name, T object) {
        if (!this.isRegistered(name) && !this.isRegistered(object)) {
            this.registry.put(name, object);
        }
    }

    public void unregister(String name) {
        if (this.isRegistered(name)) {
            this.registry.remove(name);
        }
    }

    public boolean isRegistered(T object) {
        return this.registry.containsValue(object);
    }

    public boolean isRegistered(String name) {
        return this.registry.containsKey(name);
    }

    public int size() {
        return this.registry.size();
    }

    public T getObjectByName(String name) {
        return this.registry.get(name);
    }

    public void clear() {
        this.registry.clear();
    }

    public Set<String> getKeys() {
        return this.registry.keySet();
    }
}

