/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.Sorter;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.w3c.dom.Element;

public class XAnnotatedObject {
    final XMap xmap;
    final Class klass;
    final Path path;
    final List<XAnnotatedMember> members;
    Sorter sorter;

    public XAnnotatedObject(XMap xmap, Class klass, XObject xob) {
        this.xmap = xmap;
        this.klass = klass;
        this.path = new Path(xob.value());
        this.members = new ArrayList<XAnnotatedMember>();
        String[] order = xob.order();
        if (order.length > 0) {
            this.sorter = new Sorter(order);
        }
    }

    public void addMember(XAnnotatedMember member) {
        this.members.add(member);
    }

    public Path getPath() {
        return this.path;
    }

    public Object newInstance(Context ctx, Element element) throws Exception {
        Object ob = this.klass.newInstance();
        ctx.push(ob);
        if (this.sorter != null) {
            Collections.sort(this.members, this.sorter);
            this.sorter = null;
        }
        for (XAnnotatedMember member : this.members) {
            member.process(ctx, element);
        }
        return ctx.pop();
    }
}

