/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.XAnnotatedContent;
import org.nuxeo.common.xmap.XAnnotatedList;
import org.nuxeo.common.xmap.XAnnotatedMap;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.XAnnotatedParent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLBuilder {
    private static final Log log = LogFactory.getLog(XMLBuilder.class);

    private XMLBuilder() {
    }

    public static String saveToXML(Object object, Element root, XAnnotatedObject xao) {
        try {
            XMLBuilder.toXML(object, root, xao);
            return DOMSerializer.toString(root);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static void toXML(Object o, Element parent, XAnnotatedObject xao) {
        Element currentNode = parent;
        String path = xao.getPath().toString();
        if (path.length() > 0) {
            currentNode = parent.getOwnerDocument().createElement(path);
            parent.appendChild(currentNode);
        }
        for (XAnnotatedMember m : xao.members) {
            if (m instanceof XAnnotatedMap) {
                m.toXML(o, currentNode);
                continue;
            }
            if (m instanceof XAnnotatedList) {
                m.toXML(o, currentNode);
                continue;
            }
            if (m instanceof XAnnotatedContent) {
                m.toXML(o, currentNode);
                continue;
            }
            if (m instanceof XAnnotatedParent) continue;
            m.toXML(o, currentNode);
        }
    }

    public static Element getOrCreateElement(Element root, Path path) {
        Element e = root;
        for (String segment : path.segments) {
            e = XMLBuilder.getOrCreateElement(e, segment);
        }
        return e;
    }

    public static Element addElement(Element root, Path path) {
        Element e = root;
        int len = path.segments.length - 1;
        for (int i = 0; i < len; ++i) {
            e = XMLBuilder.getOrCreateElement(e, path.segments[i]);
        }
        return XMLBuilder.addElement(e, path.segments[len]);
    }

    private static Element getOrCreateElement(Element parent, String segment) {
        NodeList list = parent.getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Element e = (Element)list.item(i);
            if (!segment.equals(e.getNodeName())) continue;
            return e;
        }
        return XMLBuilder.addElement(parent, segment);
    }

    public static Element addElement(Element parent, String segment) {
        Element e = parent.getOwnerDocument().createElement(segment);
        parent.appendChild(e);
        return e;
    }

    public static void fillField(Element element, String value, String attribute) {
        if (attribute != null) {
            element.setAttribute(attribute, value);
        } else {
            element.setTextContent(value);
        }
    }
}

