/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.function;

import java.util.function.Supplier;
import org.nuxeo.common.function.FunctionUtils;

@FunctionalInterface
public interface ThrowableSupplier<T, E extends Throwable> {
    public T get() throws E;

    default public Supplier<T> toSupplier() {
        return ThrowableSupplier.asSupplier(this);
    }

    public static <T, E extends Throwable> Supplier<T> asSupplier(ThrowableSupplier<T, E> throwableSupplier) {
        return () -> {
            try {
                return throwableSupplier.get();
            }
            catch (Throwable t) {
                return FunctionUtils.sneakyThrow(t);
            }
        };
    }
}

