/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtils {
    public static final String ISODATETIME_GENERIC_PATTERN = "yyyy[-MM][-dd['T'HH[:mm[:ss[.SSS]]]]][XXX]";
    public static final DateTimeFormatter ISO_ROBUST_DATE_TIME = DateUtils.robustOfPattern("yyyy[-MM][-dd['T'HH[:mm[:ss[.SSS]]]]][XXX]");
    public static final DateTimeFormatter[] formatters = new DateTimeFormatter[]{DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_ZONED_DATE_TIME, ISO_ROBUST_DATE_TIME};
    public static final DateTimeFormatter ISO_DATE_ONLY = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private DateUtils() {
    }

    public static String formatISODateTime(Calendar calendar) {
        return DateUtils.formatISODateTime(DateUtils.toZonedDateTime(calendar));
    }

    public static String formatISODateTime(Date date) {
        return DateUtils.formatISODateTime(DateUtils.toZonedDateTime(date));
    }

    public static String formatISODateTime(ZonedDateTime zdt) {
        return DateUtils.formatISODateTime(zdt, false);
    }

    public static String formatISODateTime(ZonedDateTime zdt, boolean dateOnly) {
        if (zdt == null) {
            return null;
        }
        if (dateOnly) {
            return ISO_DATE_ONLY.format(zdt);
        }
        return ISO_ROBUST_DATE_TIME.format(zdt);
    }

    public static Date nowIfNull(Date date) {
        return date == null ? new Date() : date;
    }

    public static Calendar nowIfNull(Calendar calendar) {
        return calendar == null ? Calendar.getInstance() : calendar;
    }

    public static ZonedDateTime nowIfNull(ZonedDateTime zdt) {
        return zdt == null ? ZonedDateTime.now() : zdt;
    }

    public static ZonedDateTime parseISODateTime(String string) {
        return DateUtils.parse(string, formatters);
    }

    public static ZonedDateTime parse(String string, DateTimeFormatter ... formatters) {
        if (string.length() > 10 && string.charAt(10) == ' ') {
            char[] s = string.toCharArray();
            s[10] = 84;
            string = new String(s);
        }
        for (DateTimeFormatter formatter : formatters) {
            try {
                TemporalAccessor ta = formatter.parseBest(string, ZonedDateTime::from, LocalDate::from);
                if (ta instanceof ZonedDateTime) {
                    return (ZonedDateTime)ta;
                }
                return ((LocalDate)ta).atStartOfDay(ZoneOffset.UTC);
            }
            catch (Exception exception) {
            }
        }
        throw new DateTimeException("Could not parse '" + string + "'");
    }

    public static final DateTimeFormatter robustOfPattern(String pattern) {
        return new DateTimeFormatterBuilder().appendPattern(pattern).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).toFormatter().withZone(ZoneOffset.UTC);
    }

    public static Calendar toCalendar(Instant instant) {
        if (instant == null) {
            return null;
        }
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
        return GregorianCalendar.from(zdt);
    }

    public static Date toDate(ZonedDateTime zdt) {
        if (zdt == null) {
            return null;
        }
        return Date.from(zdt.toInstant());
    }

    public static Instant toInstant(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.toInstant();
    }

    public static ZonedDateTime toZonedDateTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(calendar.toInstant(), ZoneOffset.UTC);
    }

    public static ZonedDateTime toZonedDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
    }
}

