/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.StringUtils;

public class FullTextUtils {
    public static final Pattern wordPattern = Pattern.compile("[\\s\\p{Punct}]+");
    public static final int MIN_SIZE = 3;
    public static final String STOP_WORDS = "a an are and as at be by for from how i in is it of on or that the this to was what when where who will with car donc est il ils je la le les mais ni nous or ou pour tu un une vous www com net org";
    public static final Set<String> stopWords = new HashSet<String>(Arrays.asList(StringUtils.split("a an are and as at be by for from how i in is it of on or that the this to was what when where who will with car donc est il ils je la le les mais ni nous or ou pour tu un une vous www com net org", ' ', false)));
    public static final String UNACCENTED = "aaaaaaaceeeeiiii\u00f0nooooo\u00f7ouuuuy\u00fey";

    private FullTextUtils() {
    }

    public static Set<String> parseFullText(String string, boolean removeDiacritics) {
        if (string == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String word : wordPattern.split(string)) {
            String w = FullTextUtils.parseWord(word, removeDiacritics);
            if (w == null) continue;
            set.add(w);
        }
        return set;
    }

    public static String parseWord(String string, boolean removeDiacritics) {
        String word;
        int len = string.length();
        if (len < 3) {
            return null;
        }
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = Character.toLowerCase(string.charAt(i));
            if (removeDiacritics) {
                if (c == '\u00e6') {
                    sb.append("ae");
                    continue;
                }
                if (c >= '\u00e0' && c <= '\u00ff') {
                    sb.append(UNACCENTED.charAt(c - 224));
                    continue;
                }
                if (c == '\u0153') {
                    sb.append("oe");
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        int l = sb.length();
        if (l > 3 && sb.charAt(l - 1) == 's') {
            sb.setLength(l - 1);
        }
        if (stopWords.contains(word = sb.toString())) {
            return null;
        }
        return word;
    }
}

