/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.common.xmap.XAccessor;
import org.nuxeo.common.xmap.XAnnotatedContent;
import org.nuxeo.common.xmap.XAnnotatedContext;
import org.nuxeo.common.xmap.XAnnotatedList;
import org.nuxeo.common.xmap.XAnnotatedMap;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XAnnotatedMembers;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.XAnnotatedParent;
import org.nuxeo.common.xmap.XAnnotatedReference;
import org.nuxeo.common.xmap.XFieldAccessor;
import org.nuxeo.common.xmap.XMLBuilder;
import org.nuxeo.common.xmap.XMethodAccessor;
import org.nuxeo.common.xmap.XValueFactory;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XContext;
import org.nuxeo.common.xmap.annotation.XMemberAnnotation;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XNodes;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.nuxeo.common.xmap.registry.SingleRegistry;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XMerge;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.common.xmap.registry.XRemove;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMap {
    private static DocumentBuilderFactory factory = XMap.initFactory();
    private final Map<String, XAnnotatedObject> roots;
    private final Map<Class<?>, XAnnotatedObject> objects = new Hashtable();
    private final Map<Class<?>, XValueFactory> factories;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilderFactory initFactory() {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(XMap.class.getClassLoader());
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilderFactory documentBuilderFactory = factory;
            return documentBuilderFactory;
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    public static DocumentBuilderFactory getFactory() {
        return factory;
    }

    public XMap() {
        this.roots = new Hashtable<String, XAnnotatedObject>();
        this.factories = new Hashtable(XValueFactory.defaultFactories);
    }

    public XValueFactory getValueFactory(Class<?> type) {
        return this.factories.get(type);
    }

    public void setValueFactory(Class<?> type, XValueFactory factory) {
        this.factories.put(type, factory);
    }

    public Collection<XAnnotatedObject> getScannedObjects() {
        return this.objects.values();
    }

    public Collection<XAnnotatedObject> getRootObjects() {
        return this.roots.values();
    }

    public XAnnotatedObject register(Class<?> klass) {
        XObject xob;
        XAnnotatedObject xao = this.objects.get(klass);
        if (xao == null && (xob = klass.getAnnotation(XObject.class)) != null) {
            xao = new XAnnotatedObject(this, klass, xob);
            this.objects.put(xao.klass, xao);
            this.scanObjectRegistryAnnotations(xao, xao.klass);
            this.scanClass(xao, xao.klass);
            String key = xob.value();
            if (key.length() > 0) {
                this.roots.put(xao.path.path, xao);
            }
        }
        return xao;
    }

    public Registry getRegistry(XAnnotatedObject xObject) {
        if (xObject == null || !xObject.hasRegistry()) {
            return null;
        }
        if (xObject.getRegistryId() != null) {
            return new MapRegistry();
        }
        return new SingleRegistry();
    }

    private void scanClass(XAnnotatedObject xob, Class<?> klass) {
        Method[] methods;
        Field[] fields;
        for (Field field : fields = klass.getDeclaredFields()) {
            Annotation anno = XMap.checkMemberAnnotation(field);
            if (anno == null) continue;
            XFieldAccessor setter = new XFieldAccessor(field);
            XAnnotatedMember member = this.createMember(anno, setter);
            xob.addMember(member);
            if (anno instanceof XNode) {
                this.scanMemberRegistryAnnotations(xob, (XNode)anno, field);
            }
            if (!(member instanceof XAnnotatedList)) continue;
            this.scanMergeAnnotations(xob, field, (XAnnotatedList)member);
        }
        for (Method method : methods = klass.getDeclaredMethods()) {
            Annotation anno;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != 1 || (anno = XMap.checkMemberAnnotation(method)) == null) continue;
            XMethodAccessor setter = new XMethodAccessor(method, klass);
            XAnnotatedMember xm = this.createMember(anno, setter);
            xob.addMember(xm);
            if (!(anno instanceof XNode)) continue;
            this.scanMemberRegistryAnnotations(xob, (XNode)anno, method);
        }
        if (klass.getSuperclass() != null) {
            this.scanClass(xob, klass.getSuperclass());
        }
    }

    private void scanObjectRegistryAnnotations(XAnnotatedObject xob, Class<?> klass) {
        XRegistry xreg = klass.getAnnotation(XRegistry.class);
        xob.setHasRegistry(xreg != null);
        XRegistryId xregistryId = klass.getAnnotation(XRegistryId.class);
        if (xregistryId != null) {
            String[] idValue = xregistryId.value();
            if (idValue.length == 1) {
                xob.setRegistryId(new XAnnotatedReference(this, String.class, idValue[0], xregistryId.fallback(), xregistryId.defaultAssignment()));
            } else {
                xob.setRegistryId(new XAnnotatedMembers(this, null, idValue, xregistryId.separator(), xregistryId.defaultAssignment()));
            }
        }
        if (xreg != null) {
            if (xreg.merge()) {
                xob.setMerge(new XAnnotatedReference(this, "@merge", null, true));
            }
            if (xreg.enable()) {
                xob.setEnable(new XAnnotatedReference(this, "@enable", null, true));
            }
            if (xreg.remove()) {
                xob.setRemove(new XAnnotatedReference(this, "@remove", null, false));
            }
            if (xreg.compatWarnOnMerge()) {
                xob.setCompatWarnOnMerge(true);
            }
        }
    }

    private void scanMemberRegistryAnnotations(XAnnotatedObject xob, XNode annotation, AnnotatedElement ae) {
        if (xob.getRegistryId() == null && ae.isAnnotationPresent(XRegistryId.class)) {
            xob.setRegistryId(new XAnnotatedReference(this, String.class, annotation.value(), annotation.fallback(), annotation.defaultAssignment()));
        }
        if (xob.getMerge() == null && ae.isAnnotationPresent(XMerge.class)) {
            XMerge merge = ae.getAnnotation(XMerge.class);
            xob.setMerge(new XAnnotatedReference(this, annotation.value(), annotation.fallback(), merge.defaultAssignment()));
        }
        if (xob.getEnable() == null && ae.isAnnotationPresent(XEnable.class)) {
            xob.setEnable(new XAnnotatedReference(this, annotation.value(), annotation.fallback(), ae.getAnnotation(XEnable.class).defaultAssignment()));
        }
        if (xob.getRemove() == null && ae.isAnnotationPresent(XRemove.class)) {
            xob.setRemove(new XAnnotatedReference(this, annotation.value(), annotation.fallback(), ae.getAnnotation(XRemove.class).defaultAssignment()));
        }
    }

    private void scanMergeAnnotations(XAnnotatedObject xob, AnnotatedElement ae, XAnnotatedList member) {
        if (ae.isAnnotationPresent(XMerge.class)) {
            XMerge merge = ae.getAnnotation(XMerge.class);
            member.setMerge(new XAnnotatedReference(this, merge.value(), merge.fallback(), merge.defaultAssignment()));
        }
        if (ae.isAnnotationPresent(XRemove.class)) {
            XRemove remove = ae.getAnnotation(XRemove.class);
            member.setRemove(new XAnnotatedReference(this, remove.value(), remove.fallback(), remove.defaultAssignment()));
        }
    }

    public Object load(URL url) throws IOException {
        return this.load(new Context(), url.openStream());
    }

    public Object load(Context ctx, URL url) throws IOException {
        return this.load(ctx, url.openStream());
    }

    public Object load(InputStream in) throws IOException {
        return this.load(new Context(), in);
    }

    public Object load(Context ctx, InputStream in) throws IOException {
        try {
            DocumentBuilderFactory factory = XMap.getFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            Object object = this.load(ctx, document.getDocumentElement());
            return object;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Object[] loadAll(URL url) throws IOException {
        return this.loadAll(new Context(), url.openStream());
    }

    public Object[] loadAll(Context ctx, URL url) throws IOException {
        return this.loadAll(ctx, url.openStream());
    }

    public Object[] loadAll(InputStream in) throws IOException {
        return this.loadAll(new Context(), in);
    }

    public Object[] loadAll(Context ctx, InputStream in) throws IOException {
        try {
            DocumentBuilderFactory factory = XMap.getFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            Object[] objectArray = this.loadAll(ctx, document.getDocumentElement());
            return objectArray;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Object load(Element root) {
        return this.load(new Context(), root);
    }

    public Object load(Context ctx, Element root) {
        String name = root.getNodeName();
        XAnnotatedObject xob = this.roots.get(name);
        if (xob != null) {
            return xob.newInstance(ctx, root);
        }
        for (Node p = root.getFirstChild(); p != null; p = p.getNextSibling()) {
            if (p.getNodeType() != 1) continue;
            return this.load(ctx, (Element)p);
        }
        return null;
    }

    public Object[] loadAll(Context ctx, Element root) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.loadAll(ctx, root, result);
        return result.toArray();
    }

    public Object[] loadAll(Element root) {
        return this.loadAll(new Context(), root);
    }

    public void loadAll(Element root, Collection<Object> result) {
        this.loadAll(new Context(), root, result);
    }

    public void loadAll(Context ctx, Element root, Collection<Object> result) {
        String name = root.getNodeName();
        XAnnotatedObject xob = this.roots.get(name);
        if (xob != null) {
            Object ob = xob.newInstance(ctx, root);
            result.add(ob);
        } else {
            for (Node p = root.getFirstChild(); p != null; p = p.getNextSibling()) {
                if (p.getNodeType() != 1) continue;
                this.loadAll(ctx, (Element)p, result);
            }
        }
    }

    public XAnnotatedObject getObject(Class<?> klass) {
        return this.objects.get(klass);
    }

    public void register(Registry registry, Context ctx, Element root, String tag) {
        if (registry == null || registry.isNull()) {
            return;
        }
        String name = root.getNodeName();
        XAnnotatedObject xob = this.roots.get(name);
        if (xob != null) {
            registry.register(ctx, xob, root, tag);
        } else {
            for (Node p = root.getFirstChild(); p != null; p = p.getNextSibling()) {
                if (p.getNodeType() != 1) continue;
                this.register(registry, ctx, (Element)p, tag);
            }
        }
    }

    public void unregister(Registry registry, String tag) {
        if (registry == null || registry.isNull()) {
            return;
        }
        registry.unregister(tag);
    }

    protected static Annotation checkMemberAnnotation(AnnotatedElement ae) {
        Annotation[] annos;
        for (Annotation anno : annos = ae.getAnnotations()) {
            if (!anno.annotationType().isAnnotationPresent(XMemberAnnotation.class)) continue;
            return anno;
        }
        return null;
    }

    private XAnnotatedMember createMember(Annotation annotation, XAccessor setter) {
        XAnnotatedMember member = null;
        int type = annotation.annotationType().getAnnotation(XMemberAnnotation.class).value();
        if (type == 1) {
            member = new XAnnotatedMember(this, setter, (XNode)annotation);
        } else if (type == 7) {
            member = new XAnnotatedMembers(this, setter, (XNodes)annotation);
        } else if (type == 2) {
            member = new XAnnotatedList(this, setter, (XNodeList)annotation);
        } else if (type == 3) {
            member = new XAnnotatedMap(this, setter, (XNodeMap)annotation);
        } else if (type == 4) {
            member = new XAnnotatedParent(this, setter);
        } else if (type == 5) {
            member = new XAnnotatedContent(this, setter, (XContent)annotation);
        } else if (type == 6) {
            member = new XAnnotatedContext(this, setter, (XContext)annotation);
        }
        return member;
    }

    public String toXML(Object object) throws IOException {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory dbfac = XMap.getFactory();
        try {
            docBuilder = dbfac.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("root");
        doc.appendChild(root);
        this.toXML(object, root);
        return DOMSerializer.toString(root);
    }

    public void toXML(Object object, OutputStream os) throws IOException {
        String xml = this.toXML(object);
        os.write(xml.getBytes());
    }

    public void toXML(Object object, File file) throws IOException {
        String xml = this.toXML(object);
        FileUtils.writeStringToFile((File)file, (String)xml, (Charset)StandardCharsets.UTF_8);
    }

    public void toXML(Object object, Element root) {
        XAnnotatedObject xao = this.objects.get(object.getClass());
        if (xao == null) {
            throw new IllegalArgumentException(object.getClass().getCanonicalName() + " is NOT registred in xmap");
        }
        XMLBuilder.saveToXML(object, root, xao);
    }
}

