/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap.registry;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.AbstractRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.w3c.dom.Element;

public class SingleRegistry
extends AbstractRegistry
implements Registry {
    private static final Logger log = LogManager.getLogger(SingleRegistry.class);
    protected volatile Object contribution;
    protected volatile boolean enabled = true;

    @Override
    public void initialize() {
        this.setContribution(null);
        this.enabled = true;
        super.initialize();
    }

    public <T> Optional<T> getContribution() {
        this.checkInitialized();
        return this.enabled ? Optional.ofNullable(this.contribution) : Optional.empty();
    }

    protected void setContribution(Object contribution) {
        this.contribution = contribution;
    }

    @Override
    public <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        Object enabled;
        Object contrib;
        XAnnotatedMember remove = xObject.getRemove();
        if (remove != null && Boolean.TRUE.equals(remove.getValue(ctx, element))) {
            this.setContribution(null);
            return null;
        }
        XAnnotatedMember merge = xObject.getMerge();
        if (merge != null && Boolean.TRUE.equals(merge.getValue(ctx, element))) {
            if (this.contribution != null && xObject.getCompatWarnOnMerge() && !merge.hasValue(ctx, element)) {
                log.warn("A contribution on extension '{}' has been implicitly merged: the compatibility mechanism on its descriptor class '{}' detected it, and the attribute merge=\"true\" should be added to this definition.", (Object)extensionId, (Object)this.contribution.getClass().getName());
            }
            contrib = xObject.newInstance(ctx, element, this.contribution);
        } else {
            contrib = xObject.newInstance(ctx, element);
        }
        this.setContribution(contrib);
        XAnnotatedMember enable = xObject.getEnable();
        if (enable != null && (enabled = enable.getValue(ctx, element)) != null) {
            this.enabled = Boolean.TRUE.equals(enabled);
        }
        return (T)contrib;
    }
}

