/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileNamePattern;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.PathFilter;

public final class FileUtils {
    private static final Log log = LogFactory.getLog(FileUtils.class);

    private FileUtils() {
    }

    public static void copy(File src, File dst) throws IOException {
        if (src.equals(dst)) {
            return;
        }
        if (src.isFile()) {
            FileUtils.copyFile(src, dst);
        } else {
            FileUtils.copyTree(src, dst);
        }
    }

    public static void copy(File[] src, File dst) throws IOException {
        for (File file : src) {
            FileUtils.copy(file, dst);
        }
    }

    @Deprecated
    public static void copyFile(File src, File dst) throws IOException {
        if (dst.isDirectory()) {
            dst = new File(dst, src.getName());
        }
        org.apache.commons.io.FileUtils.copyFile((File)src, (File)dst, (boolean)false);
    }

    @Deprecated
    public static void copyTree(File src, File dst) throws IOException {
        if (src.isFile()) {
            FileUtils.copyFile(src, dst);
        } else if (src.isDirectory()) {
            File[] files;
            if (dst.exists()) {
                dst = new File(dst, src.getName());
                dst.mkdir();
            } else {
                dst.mkdirs();
            }
            for (File file : files = src.listFiles()) {
                FileUtils.copyTree(file, dst);
            }
        }
    }

    @Deprecated
    public static void copyTree(File src, File dst, PathFilter filter) throws IOException {
        FileUtils.copyTree(src, dst, new Path("/"), filter);
    }

    public static void copyTree(File src, File dst, Path prefix, PathFilter filter) throws IOException {
        if (!prefix.isAbsolute()) {
            prefix = prefix.makeAbsolute();
        }
        int rootIndex = src.getPath().length() + 1;
        for (File file : src.listFiles()) {
            FileUtils.copyTree(rootIndex, file, new File(dst, file.getName()), prefix, filter);
        }
    }

    protected static void copyTree(int rootIndex, File src, File dst, Path prefix, PathFilter filter) throws IOException {
        if (src.isFile()) {
            String pff;
            Object path;
            int prefixIndex;
            String relPath = src.getPath().substring(rootIndex);
            if (!filter.accept(new Path(relPath))) {
                return;
            }
            if (!prefix.isRoot() && (prefixIndex = ((String)(path = dst.getPath())).lastIndexOf(pff = prefix.toString())) > 0) {
                path = ((String)path).substring(0, prefixIndex) + ((String)path).substring(prefixIndex + pff.length());
                dst = new File((String)path);
            }
            dst.getParentFile().mkdirs();
            FileUtils.copyFile(src, dst);
        } else if (src.isDirectory()) {
            File[] files;
            for (File file : files = src.listFiles()) {
                FileUtils.copyTree(rootIndex, file, new File(dst, file.getName()), prefix, filter);
            }
        }
    }

    public static String getFilePathFromUrl(URL url) {
        String path = "";
        if (url.getProtocol().equals("file")) {
            try {
                path = URLDecoder.decode(url.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
            }
        }
        return path;
    }

    public static File getFileFromURL(URL url) {
        String filename = FileUtils.getFilePathFromUrl(url);
        File file = filename.equals("") ? null : new File(filename);
        return file;
    }

    public static String getParentPath(String path) {
        int p = path.lastIndexOf(File.separator);
        if (p == -1) {
            return null;
        }
        return path.substring(0, p);
    }

    public static String getFileName(String path) {
        int p = path.lastIndexOf(File.separator);
        if (p == -1) {
            return path;
        }
        return path.substring(p + 1);
    }

    public static String getFileExtension(String path) {
        int p = path.lastIndexOf(46);
        if (p == -1) {
            return null;
        }
        return path.substring(p + 1);
    }

    public static String getFileNameNoExt(String path) {
        String name = FileUtils.getFileName(path);
        int p = name.lastIndexOf(46);
        if (p == -1) {
            return name;
        }
        return name.substring(0, p);
    }

    public static String getResourcePathFromContext(String resource) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        return FileUtils.getFilePathFromUrl(url);
    }

    public static File getResourceFileFromContext(String resource) {
        String filename = FileUtils.getResourcePathFromContext(resource);
        File file = filename.equals("") ? null : new File(filename);
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File[] findFiles(File root, String pattern, boolean recurse) {
        ArrayList<File> result = new ArrayList<File>();
        if (pattern == null) {
            if (!recurse) return root.listFiles();
            FileUtils.collectFiles(root, result);
            return result.toArray(new File[result.size()]);
        } else {
            FileNamePattern pat = new FileNamePattern(pattern);
            if (recurse) {
                FileUtils.collectFiles(root, pat, result);
                return result.toArray(new File[result.size()]);
            } else {
                File[] files;
                for (File file : files = root.listFiles()) {
                    if (!pat.match(file.getName())) continue;
                    result.add(file);
                }
            }
        }
        return result.toArray(new File[result.size()]);
    }

    public static void collectFiles(File root, FileNamePattern pattern, List<File> result) {
        File[] files;
        for (File file : files = root.listFiles()) {
            if (!pattern.match(file.getName())) continue;
            result.add(file);
            if (!file.isDirectory()) continue;
            FileUtils.collectFiles(file, pattern, result);
        }
    }

    public static void collectFiles(File root, List<File> result) {
        File[] files;
        for (File file : files = root.listFiles()) {
            result.add(file);
            if (!file.isDirectory()) continue;
            FileUtils.collectFiles(file, result);
        }
    }

    public static File urlToFile(String url) throws MalformedURLException {
        return FileUtils.urlToFile(new URL(url));
    }

    public static File urlToFile(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    public static boolean areFilesContentEquals(String expected, String source) {
        if (expected == source) {
            return true;
        }
        if (expected == null || source == null) {
            return false;
        }
        if (expected.length() != source.length()) {
            return expected.replace("\r\n", "\n").equals(source.replace("\r\n", "\n"));
        }
        return expected.equals(source);
    }

    public static String getSafeFilename(String filename) {
        return filename.replaceAll("(\\\\)|(\\/)|(\\:)|(\\*)|(\\.\\.)", "_");
    }
}

