/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap.registry;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.AbstractRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.w3c.dom.Element;

public class MapRegistry
extends AbstractRegistry
implements Registry {
    private static final Logger log = LogManager.getLogger(MapRegistry.class);
    protected Map<String, Object> contributions = Collections.synchronizedMap(new LinkedHashMap());
    protected Set<String> disabled = ConcurrentHashMap.newKeySet();
    protected static final String DEFAULT_KEY = "null";

    @Override
    public void initialize() {
        this.contributions.clear();
        this.disabled.clear();
        super.initialize();
    }

    public <T> Map<String, T> getContributions() {
        this.checkInitialized();
        return this.contributions.entrySet().stream().filter(x -> !this.disabled.contains(x.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, LinkedHashMap::new));
    }

    public <T> List<T> getContributionValues() {
        this.checkInitialized();
        return this.contributions.entrySet().stream().filter(x -> !this.disabled.contains(x.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public <T> Optional<T> getContribution(String id) {
        if (id == null) {
            id = DEFAULT_KEY;
        }
        this.checkInitialized();
        if (this.disabled.contains(id)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.contributions.get(id));
    }

    public Set<String> getDisabledContributions() {
        this.checkInitialized();
        return Collections.unmodifiableSet(this.disabled);
    }

    protected String computeId(Context ctx, XAnnotatedObject xObject, Element element) {
        String id = (String)xObject.getRegistryId().getValue(ctx, element);
        if (id == null) {
            id = DEFAULT_KEY;
        }
        return id;
    }

    protected boolean shouldMerge(Context ctx, XAnnotatedObject xObject, Element element, String extensionId, String id, Object existing) {
        if (super.shouldMerge(ctx, xObject, element, extensionId)) {
            XAnnotatedMember merge = xObject.getMerge();
            if (existing != null && xObject.getCompatWarnOnMerge() && !merge.hasValue(ctx, element) && !this.onlyHandlesEnablement(ctx, xObject, element, true)) {
                log.warn("The contribution with id '{}' on extension '{}' has been implicitly merged: the compatibility mechanism on its descriptor class '{}' detected it, and the attribute merge=\"true\" should be added to this definition.", (Object)id, (Object)extensionId, (Object)existing.getClass().getName());
            }
            return true;
        }
        return false;
    }

    @Override
    protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        String id = this.computeId(ctx, xObject, element);
        if (this.shouldRemove(ctx, xObject, element, extensionId)) {
            this.contributions.remove(id);
            return null;
        }
        Object existing = this.contributions.get(id);
        Object contrib = this.shouldMerge(ctx, xObject, element, extensionId, id, existing) ? this.getMergedInstance(ctx, xObject, element, existing) : this.getInstance(ctx, xObject, element);
        this.contributions.put(id, contrib);
        Boolean enable = this.shouldEnable(ctx, xObject, element, extensionId);
        if (enable != null) {
            if (Boolean.TRUE.equals(enable)) {
                this.disabled.remove(id);
            } else {
                this.disabled.add(id);
            }
        }
        return contrib;
    }
}

