/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap.registry;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.AbstractRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.w3c.dom.Element;

public class SingleRegistry
extends AbstractRegistry
implements Registry {
    private static final Logger log = LogManager.getLogger(SingleRegistry.class);
    protected volatile Object contribution;
    protected volatile boolean enabled = true;

    @Override
    public void initialize() {
        this.setContribution(null);
        this.enabled = true;
        super.initialize();
    }

    public <T> Optional<T> getContribution() {
        this.checkInitialized();
        return this.enabled ? Optional.ofNullable(this.contribution) : Optional.empty();
    }

    protected void setContribution(Object contribution) {
        this.contribution = contribution;
    }

    @Override
    protected boolean shouldMerge(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        if (super.shouldMerge(ctx, xObject, element, extensionId)) {
            XAnnotatedMember merge = xObject.getMerge();
            if (this.contribution != null && xObject.getCompatWarnOnMerge() && !merge.hasValue(ctx, element) && !this.onlyHandlesEnablement(ctx, xObject, element, false)) {
                log.warn("A contribution on extension '{}' has been implicitly merged: the compatibility mechanism on its descriptor class '{}' detected it, and the attribute merge=\"true\" should be added to this definition.", (Object)extensionId, (Object)this.contribution.getClass().getName());
            }
            return true;
        }
        return false;
    }

    @Override
    public <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        if (this.shouldRemove(ctx, xObject, element, extensionId)) {
            this.setContribution(null);
            return null;
        }
        Object contrib = this.shouldMerge(ctx, xObject, element, extensionId) ? this.getMergedInstance(ctx, xObject, element, this.contribution) : this.getInstance(ctx, xObject, element);
        this.setContribution(contrib);
        Boolean enable = this.shouldEnable(ctx, xObject, element, extensionId);
        if (enable != null) {
            this.enabled = Boolean.TRUE.equals(enable);
        }
        return contrib;
    }
}

