/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.util.ArrayList;

public class FileNamePattern {
    private boolean wstart = false;
    private boolean wend = false;
    private char[][] parts;

    public FileNamePattern(String pattern) {
        this.initialize(pattern);
    }

    private void initialize(String pattern) {
        int len;
        if (pattern == null || pattern.length() == 0) {
            return;
        }
        ArrayList<char[]> result = new ArrayList<char[]>();
        StringBuffer buf = new StringBuffer();
        char[] chars = pattern.toCharArray();
        char c = chars[0];
        int i = 0;
        if (c == '*') {
            this.wstart = true;
            i = 1;
        }
        while (i < chars.length) {
            c = chars[i];
            switch (c) {
                case '*': {
                    len = buf.length();
                    if (len <= 0) break;
                    result.add(FileNamePattern.toCharArray(buf, len));
                    buf.setLength(0);
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        if (c == '*') {
            this.wend = true;
        } else {
            len = buf.length();
            if (len > 0) {
                result.add(FileNamePattern.toCharArray(buf, len));
            }
        }
        this.parts = (char[][])result.toArray((T[])new char[result.size()][]);
    }

    private static char[] toCharArray(StringBuffer buf, int len) {
        char[] part = new char[len];
        buf.getChars(0, len, part, 0);
        return part;
    }

    public boolean match(String text) {
        if (this.parts == null || this.parts.length == 0) {
            if (text.length() == 0) {
                return true;
            }
            return this.wstart || this.wend;
        }
        return this.match(text.toCharArray(), 0, 0, !this.wstart);
    }

    private boolean match(char[] text, int offset, int part, boolean exactMatch) {
        if (part >= this.parts.length) {
            int len = text.length;
            if (offset > len) {
                return false;
            }
            if (offset == len) {
                return true;
            }
            return this.wend;
        }
        char[] pattern = this.parts[part];
        if (exactMatch) {
            int k = offset + pattern.length;
            if (k > text.length) {
                return false;
            }
            if (FileNamePattern.containsAt(text, offset, pattern)) {
                return this.match(text, k, part + 1, false);
            }
            return false;
        }
        int k = offset;
        while ((k = FileNamePattern.indexOf(text, pattern, k)) != -1) {
            if (this.match(text, k + pattern.length, part + 1, false)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static int indexOf(char[] chars, char[] pattern, int offset) {
        if (pattern.length > chars.length - offset) {
            return -1;
        }
        if (pattern.length == 0) {
            return 0;
        }
        int len = chars.length - pattern.length + 1;
        block0: for (int i = offset; i < len; ++i) {
            char c = pattern[0];
            if (chars[i] != c && c != '?') continue;
            for (int k = 1; k < pattern.length; ++k) {
                c = pattern[k];
                if (chars[k + i] != c && c != '?') continue block0;
            }
            return i;
        }
        return -1;
    }

    public static boolean containsAt(char[] array, int offset, char[] pattern) {
        if (offset + pattern.length > array.length) {
            return false;
        }
        if (pattern.length == 0) {
            return true;
        }
        if (array[offset] != pattern[0] && pattern[0] != '?') {
            return false;
        }
        for (int i = 1; i < pattern.length; ++i) {
            int k = offset + i;
            if (array[k] == pattern[i] || pattern[i] == '?') continue;
            return false;
        }
        return true;
    }
}

