/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> T[] arrayMerge(T[] ... arrays) {
        int count = 0;
        Class<?> klass = null;
        for (T[] array : arrays) {
            count += array.length;
            if (klass != null || array.length <= 0) continue;
            klass = array[0].getClass();
        }
        if (count == 0) {
            return arrays[0];
        }
        Object[] rv = (Object[])Array.newInstance(klass, count);
        int start = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, rv, start, array.length);
            start += array.length;
        }
        return rv;
    }

    public static <T> T[] intersect(T[] ... arrays) {
        Class<?> type = arrays.getClass().getComponentType().getComponentType();
        if (arrays.length == 0) {
            return (Object[])Array.newInstance(type, 0);
        }
        ArrayList<T> commonItems = new ArrayList<T>();
        T[] firstArray = arrays[0];
        commonItems.addAll(Arrays.asList(firstArray));
        for (int i = 1; i < arrays.length; ++i) {
            T[] array = arrays[i];
            List<T> arrayAsList = Arrays.asList(array);
            HashSet itemsToRemove = new HashSet();
            for (Object item : commonItems) {
                if (arrayAsList.contains(item)) continue;
                itemsToRemove.add(item);
            }
            commonItems.removeAll(itemsToRemove);
        }
        Object[] result = (Object[])Array.newInstance(type, commonItems.size());
        result = commonItems.toArray(result);
        return result;
    }
}

