/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.StringUtils;

public final class IdUtils {
    private static final String WORD_SPLITTING_REGEXP = "[^a-zA-Z0-9]+";
    private static final Random RANDOM = new Random(new Date().getTime());
    public static final Pattern STUPID_REGEXP = Pattern.compile("^[- .,;?!:/\\\\'\"]*$");

    private IdUtils() {
    }

    public static String generateStringId() {
        return String.valueOf(IdUtils.generateLongId());
    }

    public static long generateLongId() {
        long r = RANDOM.nextLong();
        if (r < 0L) {
            r = -r;
        }
        return r;
    }

    public static String generateId(String s, String wordSeparator, boolean lower, int maxChars) {
        String id;
        s = StringUtils.toAscii(s);
        s = s.trim();
        if (lower) {
            s = s.toLowerCase();
        }
        String[] words = s.split(WORD_SPLITTING_REGEXP);
        ArrayList<String> wordsList = new ArrayList<String>();
        for (String word : words) {
            if (word == null || word.length() <= 0) continue;
            wordsList.add(word);
        }
        if (wordsList.isEmpty()) {
            return IdUtils.generateStringId();
        }
        StringBuilder sb = new StringBuilder();
        if (maxChars > 0) {
            sb.append((String)wordsList.get(0));
            for (int i = 1; i < wordsList.size(); ++i) {
                String newWord = (String)wordsList.get(i);
                if (sb.length() + newWord.length() > maxChars) break;
                sb.append(wordSeparator).append(newWord);
            }
            id = sb.toString();
            id = id.substring(0, Math.min(id.length(), maxChars));
        } else {
            id = StringUtils.join(wordsList.toArray(), wordSeparator);
        }
        return id;
    }

    @Deprecated
    public static String generateId(String s) {
        return IdUtils.generateId(s, "-", true, 24);
    }

    @Deprecated
    public static String generatePathSegment(String s) {
        if (STUPID_REGEXP.matcher(s = s.trim()).matches()) {
            return IdUtils.generateStringId();
        }
        return s.replace("/", "-");
    }
}

