/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.codec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.function.BiFunction;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.codec.Crypto;

public class CryptoProperties
extends Properties {
    private static final Log log = LogFactory.getLog(CryptoProperties.class);
    private Crypto crypto = Crypto.NO_OP;
    private static final List<String> CRYPTO_PROPS = Arrays.asList("server.status.key", "server.crypt.keyalias", "server.crypt.keystore.path", "javax.net.ssl.keyStore", "server.crypt.keystore.pass", "javax.net.ssl.keyStorePassword", "server.crypt.secretkey");
    private byte[] cryptoID;
    private static final int SALT_LEN = 8;
    private final byte[] salt = new byte[8];
    private static final Random random = new SecureRandom();
    private Map<String, String> encrypted = new Hashtable<String, String>();
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoProperties(Properties defaults) {
        super(defaults);
        Random random = CryptoProperties.random;
        synchronized (random) {
            CryptoProperties.random.nextBytes(this.salt);
        }
        this.cryptoID = this.evalCryptoID();
    }

    private byte[] evalCryptoID() {
        byte[] ID = null;
        for (String prop : CRYPTO_PROPS) {
            ID = ArrayUtils.addAll(ID, (byte[])this.salt);
            ID = ArrayUtils.addAll((byte[])ID, (byte[])this.getProperty(prop, "").getBytes());
        }
        return this.crypto.getSHA1DigestOrEmpty(ID);
    }

    public CryptoProperties() {
        this((Properties)null);
    }

    public Crypto getCrypto() {
        String statusKey = this.getProperty("server.status.key");
        String keyAlias = this.getProperty("server.crypt.keyalias");
        String keystorePath = this.getProperty("server.crypt.keystore.path", this.getProperty("javax.net.ssl.keyStore"));
        if (keyAlias != null && keystorePath != null) {
            String keystorePass = this.getProperty("server.crypt.keystore.pass");
            keystorePass = !StringUtils.isEmpty((String)keystorePass) ? new String(Base64.decodeBase64((String)keystorePass)) : this.getProperty("javax.net.ssl.keyStorePassword", "changeit");
            try {
                return new Crypto(keystorePath, keystorePass.toCharArray(), keyAlias, statusKey.toCharArray());
            }
            catch (IOException | GeneralSecurityException e) {
                log.warn((Object)e);
                return Crypto.NO_OP;
            }
        }
        String secretKey = new String(Base64.decodeBase64((String)this.getProperty("server.crypt.secretkey", "")));
        if (!StringUtils.isEmpty((String)secretKey)) {
            try (BufferedReader in2 = new BufferedReader(new InputStreamReader(new URL(secretKey).openStream()));){
                secretKey = in2.readLine();
            }
            catch (MalformedURLException in2) {
            }
            catch (IOException e) {
                log.warn((Object)e);
                return Crypto.NO_OP;
            }
        } else {
            secretKey = statusKey;
        }
        if (secretKey == null) {
            log.warn((Object)"Missing server.status.key");
            return Crypto.NO_OP;
        }
        return new Crypto(secretKey.getBytes());
    }

    private boolean isNewCryptoProperty(String key, String value) {
        return CRYPTO_PROPS.contains(key) && !StringUtils.equals((String)value, (String)this.getProperty(key));
    }

    private void resetCrypto() {
        byte[] id = this.evalCryptoID();
        if (!Arrays.equals(id, this.cryptoID)) {
            this.cryptoID = id;
            this.crypto = this.getCrypto();
        }
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        Properties props = new Properties();
        props.load(reader);
        this.putAll(props);
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        Properties props = new Properties();
        props.load(inStream);
        this.putAll(props);
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        PropertiesGetDefaults props = new PropertiesGetDefaults();
        props.loadFromXML(in);
        if (this.defaults == null) {
            this.defaults = props.getDefaults();
        } else {
            this.defaults.putAll((Map<?, ?>)props.getDefaultProperties());
        }
        this.putAll(props);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Objects.requireNonNull(value);
        String sKey = (String)key;
        String sValue = (String)value;
        if (this.isNewCryptoProperty(sKey, sValue)) {
            Object old = super.put(sKey, sValue);
            this.resetCrypto();
            return old;
        }
        if (Crypto.isEncrypted(sValue)) {
            this.encrypted.put(sKey, sValue);
            sValue = new String(this.crypto.decrypt(sValue));
        }
        return super.put(sKey, sValue);
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        for (String string : CRYPTO_PROPS) {
            if (!t.containsKey(string)) continue;
            super.put(string, t.get(string));
        }
        this.resetCrypto();
        for (Map.Entry entry : t.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (Crypto.isEncrypted(value)) {
                this.encrypted.put(key, value);
                value = new String(this.crypto.decrypt(value));
            }
            super.put(key, value);
        }
    }

    @Override
    public synchronized Object putIfAbsent(Object key, Object value) {
        Objects.requireNonNull(value);
        String sKey = (String)key;
        String sValue = (String)value;
        if (this.get(key) != null) {
            return this.get(key);
        }
        if (this.isNewCryptoProperty(sKey, sValue)) {
            Object old = super.putIfAbsent(sKey, sValue);
            this.resetCrypto();
            return old;
        }
        if (Crypto.isEncrypted(sValue)) {
            this.encrypted.putIfAbsent(sKey, sValue);
            sValue = new String(this.crypto.decrypt(sValue));
        }
        return super.putIfAbsent(sKey, sValue);
    }

    @Override
    public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
        Objects.requireNonNull(oldValue);
        Objects.requireNonNull(newValue);
        String sKey = (String)key;
        String sOldValue = (String)oldValue;
        String sNewValue = (String)newValue;
        if (this.isNewCryptoProperty(sKey, sNewValue)) {
            if (super.replace(key, sOldValue, sNewValue)) {
                this.resetCrypto();
                return true;
            }
            return false;
        }
        if (super.replace(sKey, new String(this.crypto.decrypt(sOldValue)), new String(this.crypto.decrypt(sNewValue)))) {
            if (Crypto.isEncrypted(sNewValue)) {
                this.encrypted.put(sKey, sNewValue);
            } else {
                this.encrypted.remove(sKey);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized Object replace(Object key, Object value) {
        Objects.requireNonNull(value);
        if (!super.containsKey(key)) {
            return null;
        }
        return this.put(key, value);
    }

    @Override
    public synchronized Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        if (this.get(key) == null) {
            this.putIfAbsent(key, value);
            return value;
        }
        if (CRYPTO_PROPS.contains(key)) {
            Object newValue = super.merge(key, value, remappingFunction);
            this.resetCrypto();
            return newValue;
        }
        String sKey = (String)key;
        String sValue = (String)value;
        if (Crypto.isEncrypted(sValue)) {
            this.encrypted.put(sKey, sValue);
            sValue = new String(this.crypto.decrypt(sValue));
        }
        return super.merge(sKey, sValue, remappingFunction);
    }

    public String getRawProperty(String key) {
        return this.getProperty(key, true);
    }

    public String getRawProperty(String key, String defaultValue) {
        String val = this.getRawProperty(key);
        return val == null ? defaultValue : val;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, false);
    }

    public String getProperty(String key, boolean raw) {
        String value;
        Object oval = super.get(key);
        String string = value = oval instanceof String ? (String)oval : null;
        if (value == null) {
            if (this.defaults == null) {
                this.encrypted.remove(key);
            } else if (this.defaults instanceof CryptoProperties) {
                value = ((CryptoProperties)this.defaults).getProperty(key, raw);
            } else {
                value = this.defaults.getProperty(key);
                if (Crypto.isEncrypted(value)) {
                    this.encrypted.put(key, value);
                    if (!raw) {
                        value = new String(this.crypto.decrypt(value));
                    }
                }
            }
        } else if (raw && this.encrypted.containsKey(key)) {
            value = this.encrypted.get(key);
        }
        return value;
    }

    @Override
    public synchronized Object remove(Object key) {
        this.encrypted.remove(key);
        return super.remove(key);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        if (super.remove(key, value)) {
            this.encrypted.remove(key);
            return true;
        }
        return false;
    }

    protected class PropertiesGetDefaults
    extends Properties {
        private static final long serialVersionUID = 1L;

        protected PropertiesGetDefaults() {
        }

        public Properties getDefaults() {
            return this.defaults;
        }

        public Hashtable<String, Object> getDefaultProperties() {
            Hashtable<String, Object> h = new Hashtable<String, Object>();
            if (this.defaults != null) {
                Enumeration<?> allDefaultProperties = this.defaults.propertyNames();
                while (allDefaultProperties.hasMoreElements()) {
                    String key = (String)allDefaultProperties.nextElement();
                    String value = this.defaults.getProperty(key);
                    h.put(key, value);
                }
            }
            return h;
        }
    }
}

