/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileMatcher {
    private static final Pattern VAR = Pattern.compile("(.*)?\\{(.+):(.+)\\}(.*)?");
    protected final Pattern pattern;
    protected final String key;
    protected String value;

    public static FileMatcher getMatcher(String path) {
        Matcher m = VAR.matcher(path);
        if (m.matches()) {
            String prefix = m.group(1);
            String key = m.group(2).trim();
            String value = m.group(3).trim();
            String suffix = m.group(4);
            Pattern pattern = null;
            pattern = prefix.length() == 0 ? (suffix.length() == 0 ? Pattern.compile("(" + value + ")") : Pattern.compile("(" + value + ")" + suffix)) : (suffix.length() == 0 ? Pattern.compile(prefix + "(" + value + ")") : Pattern.compile(prefix + "(" + value + ")" + suffix));
            return new FileMatcher(pattern, key);
        }
        return new FileMatcher(null, path);
    }

    public static FileMatcher getMatcher(File file) {
        return FileMatcher.getMatcher(file.getName());
    }

    public static File getMatchingFile(String path, Map<String, Object> map) {
        File file = new File(path);
        FileMatcher matcher = FileMatcher.getMatcher(path);
        if (matcher.getPattern() == null) {
            return file;
        }
        File dir = file.getParentFile();
        File[] list = dir.listFiles();
        if (list != null) {
            for (File f : list) {
                if (!matcher.match(f.getName())) continue;
                if (map != null) {
                    map.put(matcher.getKey(), matcher.getValue());
                }
                return f;
            }
        }
        return null;
    }

    public FileMatcher(Pattern pattern, String key) {
        this.pattern = pattern;
        this.key = key;
    }

    public String getKey() {
        return this.pattern != null ? this.key : null;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getValue() {
        return this.value;
    }

    public boolean match(String name) {
        this.value = null;
        if (this.pattern != null) {
            Matcher m = this.pattern.matcher(name);
            if (m.matches()) {
                this.value = m.group(1);
                return true;
            }
            return false;
        }
        return name.equals(this.key);
    }
}

