/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.tools.report.client;

import java.util.Stack;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObjectBuilder;
import javax.json.stream.JsonParser;

public class ObjectFeeder {
    final Stack<Handler> stack = new Stack();

    public JsonArrayBuilder buildArray(JsonArrayBuilder builder, JsonParser parser) {
        if (!parser.hasNext()) {
            throw new JsonException("not an array");
        }
        if (parser.next() != JsonParser.Event.START_ARRAY) {
            throw new IllegalStateException("Not an array");
        }
        this.stack.push(new ArrayHandler(builder));
        try {
            this.dofeed(parser);
        }
        finally {
            this.stack.clear();
        }
        return builder;
    }

    public JsonObjectBuilder feed(JsonObjectBuilder builder, JsonParser parser) {
        if (!parser.hasNext()) {
            throw new JsonException("not an array");
        }
        if (parser.next() != JsonParser.Event.START_OBJECT) {
            throw new IllegalStateException("Not an array");
        }
        this.stack.push(new ObjectHandler(builder));
        try {
            this.dofeed(parser);
        }
        finally {
            this.stack.clear();
        }
        return builder;
    }

    void dofeed(JsonParser parser) {
        while (parser.hasNext()) {
            this.stack.peek().handle(parser.next(), parser);
        }
    }

    class ObjectHandler
    implements Handler {
        final JsonObjectBuilder builder;
        String name;

        ObjectHandler(JsonObjectBuilder aBuilder) {
            this.builder = aBuilder;
        }

        @Override
        public void handle(JsonParser.Event anEvent, JsonParser aParser) {
            block0 : switch (anEvent) {
                case END_OBJECT: {
                    ObjectFeeder.this.stack.pop();
                    if (ObjectFeeder.this.stack.isEmpty()) break;
                    ObjectFeeder.this.stack.peek().handle(this.builder);
                    break;
                }
                case KEY_NAME: {
                    this.name = aParser.getString();
                    switch (aParser.next()) {
                        case START_ARRAY: {
                            ObjectFeeder.this.stack.push(new ArrayHandler(Json.createArrayBuilder()));
                            break block0;
                        }
                        case START_OBJECT: {
                            ObjectFeeder.this.stack.push(new ObjectHandler(Json.createObjectBuilder()));
                            break block0;
                        }
                        case VALUE_FALSE: {
                            this.builder.add(this.name, false);
                            break block0;
                        }
                        case VALUE_TRUE: {
                            this.builder.add(this.name, true);
                            break block0;
                        }
                        case VALUE_NULL: {
                            this.builder.addNull(this.name);
                            break block0;
                        }
                        case VALUE_STRING: {
                            this.builder.add(this.name, aParser.getString());
                            break block0;
                        }
                        case VALUE_NUMBER: {
                            if (aParser.isIntegralNumber()) {
                                this.builder.add(this.name, aParser.getLong());
                                break block0;
                            }
                            this.builder.add(this.name, aParser.getBigDecimal());
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Cannot handle " + anEvent + " while parsing object");
                }
                default: {
                    throw new IllegalStateException("Cannot handle " + anEvent + " while parsing object");
                }
            }
        }

        @Override
        public void handle(JsonArrayBuilder builder) {
            this.builder.add(this.name, builder);
        }

        @Override
        public void handle(JsonObjectBuilder builder) {
            this.builder.add(this.name, builder);
        }
    }

    class ArrayHandler
    implements Handler {
        final JsonArrayBuilder builder;

        ArrayHandler(JsonArrayBuilder aBuilder) {
            this.builder = aBuilder;
        }

        @Override
        public void handle(JsonParser.Event event, JsonParser parser) {
            switch (event) {
                case START_ARRAY: {
                    ObjectFeeder.this.stack.push(new ArrayHandler(Json.createArrayBuilder()));
                    break;
                }
                case START_OBJECT: {
                    ObjectFeeder.this.stack.push(new ObjectHandler(Json.createObjectBuilder()));
                    break;
                }
                case END_ARRAY: {
                    ObjectFeeder.this.stack.pop();
                    ObjectFeeder.this.stack.peek().handle(this.builder);
                    break;
                }
                case END_OBJECT: {
                    ObjectFeeder.this.stack.pop();
                    ObjectFeeder.this.stack.peek().handle(this.builder);
                    break;
                }
                case VALUE_FALSE: {
                    this.builder.add(false);
                    break;
                }
                case VALUE_TRUE: {
                    this.builder.add(true);
                    break;
                }
                case VALUE_STRING: {
                    this.builder.add(parser.getString());
                    break;
                }
                case VALUE_NULL: {
                    this.builder.addNull();
                    break;
                }
                case VALUE_NUMBER: {
                    if (parser.isIntegralNumber()) {
                        this.builder.add(parser.getLong());
                        break;
                    }
                    this.builder.add(parser.getBigDecimal());
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot handle " + event + " while parsing object");
                }
            }
        }

        @Override
        public void handle(JsonArrayBuilder builder) {
            this.builder.add(builder);
        }

        @Override
        public void handle(JsonObjectBuilder builder) {
            this.builder.add(builder);
        }
    }

    static interface Handler {
        public void handle(JsonArrayBuilder var1);

        public void handle(JsonObjectBuilder var1);

        public void handle(JsonParser.Event var1, JsonParser var2);
    }
}

