/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.tools.report.client;

import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;

public class StreamFeeder {
    public void feed(JsonGenerator generator, JsonParser parser) {
        parser.next();
        block21: while (parser.hasNext()) {
            switch (parser.next()) {
                case START_ARRAY: {
                    generator.writeStartArray();
                    continue block21;
                }
                case END_ARRAY: {
                    generator.writeEnd();
                    continue block21;
                }
                case START_OBJECT: {
                    generator.writeStartObject();
                    continue block21;
                }
                case END_OBJECT: {
                    if (!parser.hasNext()) continue block21;
                    generator.writeEnd();
                    continue block21;
                }
                case KEY_NAME: {
                    String name = parser.getString();
                    switch (parser.next()) {
                        case START_ARRAY: {
                            generator.writeStartArray(name);
                            continue block21;
                        }
                        case START_OBJECT: {
                            generator.writeStartObject(name);
                            continue block21;
                        }
                        case VALUE_FALSE: {
                            generator.write(name, false);
                            continue block21;
                        }
                        case VALUE_TRUE: {
                            generator.write(name, true);
                            continue block21;
                        }
                        case VALUE_NULL: {
                            generator.writeNull(name);
                            continue block21;
                        }
                        case VALUE_STRING: {
                            generator.write(name, parser.getString());
                            continue block21;
                        }
                        case VALUE_NUMBER: {
                            if (parser.isIntegralNumber()) {
                                generator.write(name, parser.getLong());
                                continue block21;
                            }
                            generator.write(name, parser.getBigDecimal());
                            continue block21;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                case VALUE_TRUE: {
                    generator.write(true);
                    continue block21;
                }
                case VALUE_FALSE: {
                    generator.write(false);
                    continue block21;
                }
                case VALUE_NULL: {
                    generator.writeNull();
                    continue block21;
                }
                case VALUE_STRING: {
                    generator.write(parser.getString());
                    continue block21;
                }
                case VALUE_NUMBER: {
                    if (parser.isIntegralNumber()) {
                        generator.write(parser.getLong());
                        continue block21;
                    }
                    generator.write(parser.getBigDecimal());
                    continue block21;
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

