/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.tools.report.client;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.tools.report.ReportServer;
import org.nuxeo.connect.tools.report.client.ObjectFeeder;
import org.nuxeo.connect.tools.report.client.StreamFeeder;

public class ReportConnector {
    static final ObjectName NAME = ReportConnector.name();

    static ObjectName name() {
        try {
            return new ObjectName("org.nuxeo:type=service,name=connect-report");
        }
        catch (MalformedObjectNameException cause) {
            throw new AssertionError("Cannot name report", cause);
        }
    }

    public static ReportConnector of() {
        return new ReportConnector();
    }

    public JsonGenerator feed(final JsonGenerator generator) throws IOException, InterruptedException, ExecutionException {
        class Feeder
        implements Consumer {
            StreamFeeder feeder = new StreamFeeder();

            Feeder() {
            }

            @Override
            public void consume(JsonParser stream) {
                this.feeder.feed(generator, stream);
            }
        }
        this.connect(new Feeder());
        return generator;
    }

    public JsonObjectBuilder feed(final JsonObjectBuilder builder) throws IOException, InterruptedException, ExecutionException {
        class Feeder
        implements Consumer {
            ObjectFeeder feeder = new ObjectFeeder();

            Feeder() {
            }

            @Override
            public void consume(JsonParser stream) {
                this.feeder.feed(builder, stream);
            }
        }
        this.connect(new Feeder());
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <A> void connect(final Consumer consumer) throws IOException, InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable target) {
                Thread thread = new Thread(target, "connect-report");
                thread.setDaemon(true);
                return thread;
            }
        });
        try {
            for (final ReportServer server : new Discovery()) {
                final ServerSocket callback = new ServerSocket(0);
                Throwable throwable = null;
                try {
                    Future<?> consumed = executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            String name = Thread.currentThread().getName();
                            Thread.currentThread().setName("connect-report-consumer-" + server);
                            try (InputStream source = callback.accept().getInputStream();){
                                consumer.consume(Json.createParser((InputStream)source));
                            }
                            catch (IOException | JsonParsingException cause) {
                                throw new AssertionError("Cannot consume connect report", cause);
                            }
                            finally {
                                Thread.currentThread().setName(name);
                            }
                            LogFactory.getLog(ReportConnector.class).info((Object)("Consumed " + server));
                        }
                    });
                    Future<?> served = executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            String name = Thread.currentThread().getName();
                            Thread.currentThread().setName("connect-report-server-" + server);
                            InetSocketAddress address = (InetSocketAddress)callback.getLocalSocketAddress();
                            try {
                                server.run(address.getHostName(), address.getPort(), new String[0]);
                            }
                            catch (IOException cause) {
                                throw new AssertionError("Cannot run connect report", cause);
                            }
                            finally {
                                Thread.currentThread().setName(name);
                            }
                        }
                    });
                    ExecutionException consumerError = null;
                    try {
                        consumed.get();
                    }
                    catch (ExecutionException cause) {
                        consumerError = cause;
                    }
                    try {
                        served.get();
                    }
                    catch (ExecutionException cause) {
                        if (consumerError != null) {
                            consumerError.addSuppressed(cause);
                            throw consumerError;
                        }
                        throw cause;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (callback == null) continue;
                    if (throwable != null) {
                        try {
                            callback.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    callback.close();
                }
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    public Iterable<ReportServer> discover() {
        try {
            class ToolsRunner {
                ToolsRunner() {
                }

                Iterable<ReportServer> discover() {
                    try {
                        ReportConnector.class.getClassLoader().loadClass("com.sun.tools.attach.VirtualMachine");
                    }
                    catch (ClassNotFoundException cause) {
                        ClassLoader previous = Thread.currentThread().getContextClassLoader();
                        class Loader
                        extends URLClassLoader {
                            Loader(Path path) {
                                super(new URL[]{this.fileof(path)});
                            }

                            @Override
                            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                                if (name.equals(Discovery.class.getName())) {
                                    return this.findClass(name);
                                }
                                return super.loadClass(name, resolve);
                            }
                        }
                        Loader loader = new Loader(this.findTools());
                        Thread.currentThread().setContextClassLoader(loader);
                        try {
                            Iterable iterable = (Iterable)loader.loadClass(Discovery.class.getName()).newInstance();
                            return iterable;
                        }
                        catch (ReflectiveOperationException cause1) {
                            throw new AssertionError("Cannot discover servers", cause1);
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(previous);
                        }
                    }
                    return new Discovery();
                }

                URL fileof(Path path) {
                    try {
                        return new URL("file://".concat(path.toString()));
                    }
                    catch (MalformedURLException cause) {
                        throw new AssertionError("Cannot create url for " + path, cause);
                    }
                }

                Path findTools() {
                    Path home = Paths.get(System.getProperty("java.home"), new String[0]);
                    for (Path path : new Path[]{Paths.get("../lib/tools.jar", new String[0]), Paths.get("../Classes/classes.jar", new String[0])}) {
                        Path tools = home.resolve(path);
                        if (!Files.exists(tools, new LinkOption[0])) continue;
                        return tools;
                    }
                    throw new AssertionError((Object)"Cannot find tools in system");
                }
            }
            return new ToolsRunner().discover();
        }
        catch (Exception cause) {
            throw new AssertionError("Cannot discover servers", cause);
        }
    }

    static interface Consumer {
        public void consume(JsonParser var1);
    }

    static class Discovery
    implements Iterable<ReportServer> {
        Discovery() {
        }

        @Override
        public Iterator<ReportServer> iterator() {
            return new Iterator<ReportServer>(){
                final Iterator<VirtualMachineDescriptor> source = VirtualMachine.list().iterator();
                ReportServer next = this.fetchNext();

                ReportServer fetchNext() {
                    if (!this.source.hasNext()) {
                        return null;
                    }
                    while (this.source.hasNext()) {
                        VirtualMachineDescriptor pid = this.source.next();
                        try {
                            MBeanServerConnection connection = new Management(pid).connect();
                            if (!connection.isRegistered(NAME)) continue;
                            return JMX.newMXBeanProxy(connection, NAME, ReportServer.class);
                        }
                        catch (IOException cause) {
                            LogFactory.getLog(Discovery.class).error((Object)("Cannot connect to " + pid), (Throwable)cause);
                        }
                    }
                    return null;
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public ReportServer next() {
                    try {
                        ReportServer reportServer = this.next;
                        return reportServer;
                    }
                    finally {
                        this.next = this.fetchNext();
                    }
                }

                class Management {
                    final VirtualMachineDescriptor pid;

                    Management(VirtualMachineDescriptor anIdentifier) {
                        this.pid = anIdentifier;
                    }

                    MBeanServerConnection connect() throws IOException {
                        VirtualMachine vm;
                        try {
                            vm = this.pid.provider().attachVirtualMachine(this.pid);
                        }
                        catch (AttachNotSupportedException cause) {
                            throw new IOException("Cannot attach to " + this.pid, cause);
                        }
                        try {
                            MBeanServerConnection mBeanServerConnection = this.connect(this.lookup(vm));
                            return mBeanServerConnection;
                        }
                        finally {
                            vm.detach();
                        }
                    }

                    JMXServiceURL lookup(VirtualMachine vm) throws IOException {
                        JMXServiceURL url = this.lookupRemote(vm);
                        if (url != null) {
                            return url;
                        }
                        return this.lookupAgent(vm);
                    }

                    JMXServiceURL lookupRemote(VirtualMachine vm) throws IOException {
                        boolean isRemote = Boolean.valueOf(vm.getSystemProperties().getProperty("com.sun.management.jmxremote", "false"));
                        if (!isRemote) {
                            return null;
                        }
                        int port = Integer.valueOf(vm.getSystemProperties().getProperty("com.sun.management.jmxremote.port", "1089"));
                        return new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://localhost:%d/jmxrmi", port));
                    }

                    JMXServiceURL lookupAgent(VirtualMachine vm) throws IOException {
                        String address = vm.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress");
                        if (address != null) {
                            return new JMXServiceURL(address);
                        }
                        this.startAgent(vm);
                        return this.lookupAgent(vm);
                    }

                    void startAgent(VirtualMachine vm) throws IOException {
                        String home = vm.getSystemProperties().getProperty("java.home");
                        String agent = home + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
                        File f = new File(agent);
                        if (!f.exists() && !(f = new File(agent = home + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
                            throw new IOException("Management agent not found");
                        }
                        agent = f.getCanonicalPath();
                        try {
                            vm.loadAgent(agent, "com.sun.management.jmxremote");
                        }
                        catch (AgentLoadException x) {
                            IOException ioe = new IOException(x.getMessage());
                            ioe.initCause(x);
                            throw ioe;
                        }
                        catch (AgentInitializationException x) {
                            IOException ioe = new IOException(x.getMessage());
                            ioe.initCause(x);
                            throw ioe;
                        }
                    }

                    MBeanServerConnection connect(JMXServiceURL url) throws IOException {
                        return JMXConnectorFactory.connect(url).getMBeanServerConnection();
                    }
                }
            };
        }
    }
}

