/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.csv.CSVImportLog;
import org.nuxeo.ecm.csv.CSVImportResult;
import org.nuxeo.ecm.csv.CSVImportStatus;
import org.nuxeo.ecm.csv.CSVImporter;
import org.nuxeo.ecm.csv.CSVImporterOptions;
import org.nuxeo.ecm.csv.CSVImporterWork;
import org.nuxeo.runtime.api.Framework;

public class CSVImporterImpl
implements CSVImporter {
    @Override
    public String launchImport(CoreSession session, String parentPath, File csvFile, String csvFileName, CSVImporterOptions options) {
        CSVImporterWork work = new CSVImporterWork(session.getRepositoryName(), parentPath, session.getPrincipal().getName(), csvFile, csvFileName, options);
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_RUNNING_OR_SCHEDULED);
        return work.getId();
    }

    @Override
    public CSVImportStatus getImportStatus(String id) {
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        Work.State state = workManager.getWorkState(id);
        if (state == null) {
            return null;
        }
        if (state == Work.State.COMPLETED) {
            return new CSVImportStatus(CSVImportStatus.State.COMPLETED);
        }
        if (state == Work.State.SCHEDULED) {
            String queueId = workManager.getCategoryQueueId("csvImporter");
            int queueSize = workManager.getQueueSize(queueId, Work.State.SCHEDULED);
            return new CSVImportStatus(CSVImportStatus.State.SCHEDULED, 0, queueSize);
        }
        return new CSVImportStatus(CSVImportStatus.State.RUNNING);
    }

    @Override
    public List<CSVImportLog> getImportLogs(String id) {
        return this.getLastImportLogs(id, -1);
    }

    @Override
    public List<CSVImportLog> getImportLogs(String id, CSVImportLog.Status ... status) {
        return this.getLastImportLogs(id, -1, status);
    }

    @Override
    public List<CSVImportLog> getLastImportLogs(String id, int max) {
        int[] pos;
        CSVImporterWork workId;
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        Work work = workManager.find((Work)(workId = new CSVImporterWork(id)), null, true, pos = new int[1]);
        if (work == null && (work = workManager.find((Work)workId, Work.State.COMPLETED, true, pos)) == null) {
            return Collections.emptyList();
        }
        List<CSVImportLog> importLogs = ((CSVImporterWork)work).getImportLogs();
        max = max == -1 || max > importLogs.size() ? importLogs.size() : max;
        return importLogs.subList(importLogs.size() - max, importLogs.size());
    }

    @Override
    public List<CSVImportLog> getLastImportLogs(String id, int max, CSVImportLog.Status ... status) {
        List<CSVImportLog> importLogs = this.getLastImportLogs(id, max);
        return status.length == 0 ? importLogs : this.filterImportLogs(importLogs, status);
    }

    protected List<CSVImportLog> filterImportLogs(List<CSVImportLog> importLogs, CSVImportLog.Status ... status) {
        List<CSVImportLog.Status> statusList = Arrays.asList(status);
        ArrayList<CSVImportLog> filteredLogs = new ArrayList<CSVImportLog>();
        for (CSVImportLog log : importLogs) {
            if (!statusList.contains((Object)log.getStatus())) continue;
            filteredLogs.add(log);
        }
        return filteredLogs;
    }

    @Override
    public CSVImportResult getImportResult(String id) {
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        CSVImporterWork work = new CSVImporterWork(id);
        int[] pos = new int[1];
        if ((work = workManager.find((Work)work, Work.State.COMPLETED, true, pos)) == null) {
            return null;
        }
        List<CSVImportLog> importLogs = work.getImportLogs();
        return CSVImportResult.fromImportLogs(importLogs);
    }
}

