/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.dam;

import java.util.List;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.dam.AssetCreationFancyBoxFragment;
import org.nuxeo.functionaltests.dam.BulkEditFancyBoxFragment;
import org.nuxeo.functionaltests.dam.DAMPage;
import org.nuxeo.functionaltests.forms.LayoutElement;
import org.nuxeo.functionaltests.fragment.WebFragment;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;

public class SearchResultsFragment
extends WebFragmentImpl {
    @FindBy(id="nxl_gridDamLayout:nxw_damNewAsset_form:nxw_doc_damSearchResultsActions_damNewAsset_subview:nxw_doc_damSearchResultsActions_damNewAsset_link")
    public WebElement newAssetButton;
    @FindBy(id="nxl_gridDamLayout:dam_search_nxw_searchResults:nxl_dam_box_listing_ajax:damPanelLeft_header")
    public WebElement selectAllCheckbox;

    public SearchResultsFragment(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    public DAMPage createAsset(DAMPage damPage, String type, String title, String description, String originalAuthor, String authoringDate) {
        this.newAssetButton.click();
        AssetCreationFancyBoxFragment fancyBoxFragment = this.showAssetCreation(damPage);
        LayoutElement layout = new LayoutElement(this.driver, "nxl_gridDamLayout:nxw_doc_damSearchResultsActions_damNewAsset_fancyform");
        Select select = new Select(layout.getSubElement("nxw_damNewAsset_after_view_select"));
        select.selectByValue(type);
        AbstractTest.waitForTextPresent((By)By.id((String)"fancybox-content"), (String)"You can upload files of any format");
        layout.getWidget("nxl_heading:nxw_title").setInputValue(title);
        layout.getWidget("nxl_heading:nxw_description").setInputValue(description);
        layout.getWidget("nxl_dam_common:nxw_damc_author_1").setInputValue(originalAuthor);
        layout.getWidget("nxl_dam_common:nxw_damc_authoringDate_1InputDate").setInputValue(authoringDate);
        fancyBoxFragment.findElement(By.xpath((String)"//div[@id='fancybox-content']//input[@value='Create']")).click();
        return (DAMPage)((Object)damPage.asPage(DAMPage.class));
    }

    public AssetCreationFancyBoxFragment showAssetCreation(DAMPage currentPage) {
        this.newAssetButton.click();
        WebElement element = currentPage.getFancyBoxContent();
        return (AssetCreationFancyBoxFragment)this.getWebFragment(element, AssetCreationFancyBoxFragment.class);
    }

    public WebFragment getBubbleBox(String text) {
        List elements = this.element.findElements(By.className((String)"jsDamItem"));
        for (WebElement ele : elements) {
            if (!ele.getText().contains(text)) continue;
            return new WebFragmentImpl(this.driver, ele);
        }
        throw new NoSuchElementException(String.format("No bubble box found with text '%s'", text));
    }

    public void selectAsset(String text) {
        this.getBubbleBox(text).click();
    }

    public WebFragment getSelectedAsset() {
        return new WebFragmentImpl(this.driver, this.element.findElement(By.cssSelector((String)".jsDamItem.selectedItem")));
    }

    public void selectAll() {
        this.selectAllCheckbox.click();
    }

    public BulkEditFancyBoxFragment showBulkEdit(DAMPage currentPage) {
        WebElement bulkEditButton = AbstractTest.findElementAndWaitUntilEnabled((By)By.id((String)"nxl_gridDamLayout:dam_search_nxw_searchResults_buttons:nxw_damBulkEdit_form:nxw_cvButton_damBulkEdit_subview:nxw_cvButton_damBulkEdit_link"));
        bulkEditButton.click();
        WebElement element = currentPage.getFancyBoxContent();
        return (BulkEditFancyBoxFragment)this.getWebFragment(element, BulkEditFancyBoxFragment.class);
    }
}

