/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.dam;

import java.util.List;
import org.junit.Assert;
import org.nuxeo.functionaltests.dam.FoldableBoxFragment;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AssetViewFragment
extends WebFragmentImpl {
    @FindBy(xpath="//div[@id='nxl_gridDamLayout:nxw_doc_damAssetView_panel']//div[@class='documentTitle']")
    public WebElement assetTitle;

    public AssetViewFragment(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    public String getAssetTitle() {
        return this.assetTitle.getText();
    }

    public void checkAssetTitle(String expectedTitle) {
        Assert.assertEquals((Object)expectedTitle, (Object)this.getAssetTitle());
    }

    public void clickOnAction(String actionTitle) {
        String xpath = String.format("//div[@id='nxl_gridDamLayout:nxw_doc_damAssetView_panel']//img[@title='%s']", actionTitle);
        this.element.findElement(By.xpath((String)xpath)).click();
    }

    public FoldableBoxFragment getFoldableBox(String title, boolean isAjax) {
        List elements = this.element.findElements(By.className((String)"foldableBox"));
        for (WebElement ele : elements) {
            if (!ele.findElement(By.tagName((String)"h3")).getText().contains(title)) continue;
            FoldableBoxFragment foldableBox = (FoldableBoxFragment)this.getWebFragment(ele.findElement(By.xpath((String)"..")), FoldableBoxFragment.class);
            foldableBox.setAjax(isAjax);
            return foldableBox;
        }
        throw new NoSuchElementException(String.format("No foldable box found with text '%s'", title));
    }
}

