/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.importer.jaxrs;

import java.io.File;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.dam.DamService;
import org.nuxeo.dam.importer.core.DamMultiThreadedImporter;
import org.nuxeo.dam.importer.core.filter.DamImporterFilter;
import org.nuxeo.dam.importer.core.filter.DamImportingDocumentFilter;
import org.nuxeo.ecm.platform.importer.base.ImporterRunner;
import org.nuxeo.ecm.platform.importer.base.ImporterRunnerConfiguration;
import org.nuxeo.ecm.platform.importer.executor.jaxrs.AbstractJaxRSImporterExecutor;
import org.nuxeo.ecm.platform.importer.factories.FileManagerDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.factories.ImporterDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.filter.EventServiceConfiguratorFilter;
import org.nuxeo.ecm.platform.importer.filter.ImporterFilter;
import org.nuxeo.ecm.platform.importer.filter.ImportingDocumentFilter;
import org.nuxeo.ecm.platform.importer.source.FileWithMetadataSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.runtime.api.Framework;

@Path(value="damImporter")
public class HttpDamImporterExecutor
extends AbstractJaxRSImporterExecutor {
    private static final Log log = LogFactory.getLog(HttpDamImporterExecutor.class);

    protected Log getJavaLogger() {
        return log;
    }

    @GET
    @Path(value="run")
    @Produces(value={"text/plain; charset=UTF-8"})
    public String run(@QueryParam(value="inputPath") String inputPath, @QueryParam(value="importFolderTitle") String importFolderTitle, @QueryParam(value="importFolderPath") String importFolderPath, @QueryParam(value="importSetTitle") String importSetTitle, @QueryParam(value="batchSize") Integer batchSize, @QueryParam(value="nbThreads") Integer nbThreads, @QueryParam(value="interactive") Boolean interactive) throws Exception {
        File srcFile = new File(inputPath);
        FileWithMetadataSourceNode source = new FileWithMetadataSourceNode(srcFile);
        DamService damService = (DamService)Framework.getLocalService(DamService.class);
        ImporterRunnerConfiguration configuration = new ImporterRunnerConfiguration.Builder((SourceNode)source, damService.getAssetLibraryPath(), this.getLogger()).batchSize(batchSize).nbThreads(nbThreads).build();
        DamMultiThreadedImporter runner = importFolderPath != null ? DamMultiThreadedImporter.createWithImportFolderPath((ImporterRunnerConfiguration)configuration, (String)importFolderPath, (String)importSetTitle) : DamMultiThreadedImporter.createWithImportFolderTitle((ImporterRunnerConfiguration)configuration, (String)importFolderTitle, (String)importSetTitle);
        runner.setFactory((ImporterDocumentModelFactory)new FileManagerDocumentModelFactory());
        EventServiceConfiguratorFilter filter = new EventServiceConfiguratorFilter(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true));
        runner.addFilter((ImporterFilter)filter);
        runner.addFilter((ImporterFilter)new DamImporterFilter());
        runner.addImportingDocumentFilters(new ImportingDocumentFilter[]{new DamImportingDocumentFilter()});
        return this.doRun((ImporterRunner)runner, interactive);
    }
}

