/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.dam.AllowedAssetTypeDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class AllowedAssetTypeRegistry
extends ContributionFragmentRegistry<AllowedAssetTypeDescriptor> {
    protected Map<String, AllowedAssetTypeDescriptor> allowedAssetTypes = new HashMap<String, AllowedAssetTypeDescriptor>();

    public List<String> getAllowedAssetTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (AllowedAssetTypeDescriptor allowedAssetType : this.allowedAssetTypes.values()) {
            types.add(allowedAssetType.getName());
        }
        return types;
    }

    public String getContributionId(AllowedAssetTypeDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, AllowedAssetTypeDescriptor contrib, AllowedAssetTypeDescriptor newOrigContrib) {
        if (contrib.isEnabled()) {
            this.allowedAssetTypes.put(id, contrib);
        } else {
            this.allowedAssetTypes.remove(id);
        }
    }

    public void contributionRemoved(String id, AllowedAssetTypeDescriptor origContrib) {
        this.allowedAssetTypes.remove(id);
    }

    public AllowedAssetTypeDescriptor clone(AllowedAssetTypeDescriptor orig) {
        return new AllowedAssetTypeDescriptor(orig);
    }

    public void merge(AllowedAssetTypeDescriptor src, AllowedAssetTypeDescriptor dst) {
        boolean enabled = src.isEnabled();
        if (enabled != dst.isEnabled()) {
            dst.setEnabled(enabled);
        }
    }
}

