/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.seam;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.dam.AssetLibrary;
import org.nuxeo.dam.DamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="damActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class DamActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MAIN_TABS_DAM = "MAIN_TABS:dam";
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient DocumentActions documentActions;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    protected String selectedNewAssetType;

    public String getSelectedDocumentId() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return currentDocument != null ? currentDocument.getId() : null;
    }

    public void setSelectedDocumentId(String selectedDocumentId) throws ClientException {
        DocumentModel selectedDocument = this.documentManager.getDocument((DocumentRef)new IdRef(selectedDocumentId));
        this.navigationContext.setCurrentDocument(selectedDocument);
    }

    public void selectDocument(DocumentModel doc) throws ClientException {
        this.navigationContext.setCurrentDocument(doc);
    }

    public String getDamMainTab() {
        return MAIN_TABS_DAM;
    }

    public void setDamMainTab(String tabs) {
        this.webActions.setCurrentTabIds(!StringUtils.isBlank((String)tabs) ? tabs : MAIN_TABS_DAM);
    }

    public boolean getCanCreateInAssetLibrary() throws ClientException {
        AssetLibrary assetLibrary = this.getAssetLibrary();
        PathRef assetLibraryRef = new PathRef(assetLibrary.getPath());
        return this.documentManager.hasPermission((DocumentRef)assetLibraryRef, "AddChildren");
    }

    public boolean getCanCreateNewAsset() throws ClientException {
        return !this.getAllowedAssetTypes().isEmpty() && this.getCanCreateInAssetLibrary();
    }

    public AssetLibrary getAssetLibrary() {
        return ((DamService)Framework.getLocalService(DamService.class)).getAssetLibrary();
    }

    public List<Type> getAllowedAssetTypes() {
        return ((DamService)Framework.getLocalService(DamService.class)).getAllowedAssetTypes();
    }

    public String getSelectedNewAssetType() throws ClientException {
        if (this.selectedNewAssetType == null) {
            List<Type> allowedAssetTypes = this.getAllowedAssetTypes();
            if (!allowedAssetTypes.isEmpty()) {
                this.selectedNewAssetType = allowedAssetTypes.get(0).getId();
            }
            if (this.selectedNewAssetType != null) {
                this.selectNewAssetType();
            }
        }
        return this.selectedNewAssetType;
    }

    public void setSelectedNewAssetType(String selectedNewAssetType) {
        this.selectedNewAssetType = selectedNewAssetType;
    }

    public void selectNewAssetType() throws ClientException {
        String selectedType = this.getSelectedNewAssetType();
        if (selectedType == null) {
            return;
        }
        HashMap context = new HashMap();
        DocumentModel changeableDocument = this.documentManager.createDocumentModel(selectedType, context);
        this.navigationContext.setChangeableDocument(changeableDocument);
    }

    public void saveNewAsset() throws ClientException {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        if (changeableDocument.getId() != null) {
            return;
        }
        PathSegmentService pss = (PathSegmentService)Framework.getLocalService(PathSegmentService.class);
        changeableDocument.setPathInfo(this.getAssetLibrary().getPath(), pss.generatePathSegment(changeableDocument));
        changeableDocument = this.documentManager.createDocument(changeableDocument);
        this.documentManager.save();
        this.cancelNewAsset();
        this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("document_saved"), new Object[]{this.messages.get(changeableDocument.getType())});
    }

    public void cancelNewAsset() {
        this.navigationContext.setChangeableDocument(null);
        this.setSelectedNewAssetType(null);
    }

    public String viewInDM() throws ClientException {
        this.webActions.setCurrentTabIds("MAIN_TABS:documents");
        return this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument());
    }

    public String updateCurrentDocument() throws ClientException {
        this.documentActions.updateCurrentDocument();
        return null;
    }
}

