/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.repository.AbstractRepositoryTestCase;
import org.nuxeo.ecm.platform.annotations.repository.URNDocumentViewTranslator;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;

public class AnnotationsOnVersionTest
extends AbstractRepositoryTestCase {
    private static final Log log = LogFactory.getLog(AnnotationsOnVersionTest.class);
    private static final String SERVER = "http://server.com/nuxeo/";
    private final NuxeoPrincipal user = new UserPrincipal("Administrator", new ArrayList(), false, false);
    private final URNDocumentViewTranslator translator = new URNDocumentViewTranslator();

    @Test
    public void testAnnotationsOnVersion() throws Exception {
        DocumentModel docModel = this.createDocument(this.session.getRootDocument().getPathAsString(), "fileAnnotationsOnVersion");
        String url = this.viewCodecManager.getUrlFromDocumentView((DocumentView)new DocumentViewImpl(docModel), true, SERVER);
        Assert.assertNotNull((Object)url);
        this.addAnnotationOn(url);
        URI uri = this.translator.getNuxeoUrn(docModel.getRepositoryName(), docModel.getId());
        List annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)1L, (long)annotations.size());
        DocumentRef versionRef = this.checkIn(docModel.getRef());
        annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)0L, (long)annotations.size());
        log.debug((Object)(annotations.size() + " annotations for: " + uri));
        DocumentModel versionModel = this.session.getDocument(versionRef);
        URI uriVersion = this.translator.getNuxeoUrn(versionModel.getRepositoryName(), versionModel.getId());
        annotations = this.service.queryAnnotations(uriVersion, this.user);
        log.debug((Object)(annotations.size() + " annotations for: " + uriVersion));
        Assert.assertEquals((long)1L, (long)annotations.size());
        this.addAnnotationOn(url);
        annotations = this.service.queryAnnotations(uri, this.user);
        log.debug((Object)(annotations.size() + " annotations for: " + uri));
        Assert.assertEquals((long)1L, (long)annotations.size());
        annotations = this.service.queryAnnotations(uriVersion, this.user);
        log.debug((Object)(annotations.size() + " annotations for: " + uriVersion));
        Assert.assertEquals((long)1L, (long)annotations.size());
    }

    @Test
    public void testAnnotationsOnRestore() throws Exception {
        DocumentModel docModel = this.createDocument(this.session.getRootDocument().getPathAsString(), "fileAnnotationsOnRestore");
        String url = this.viewCodecManager.getUrlFromDocumentView((DocumentView)new DocumentViewImpl(docModel), true, SERVER);
        Assert.assertNotNull((Object)url);
        this.addAnnotationOn(url);
        URI uri = this.translator.getNuxeoUrn(docModel.getRepositoryName(), docModel.getId());
        List annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)1L, (long)annotations.size());
        DocumentRef versionRef = this.checkIn(docModel.getRef());
        annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)0L, (long)annotations.size());
        DocumentModel versionModel = this.session.getDocument(versionRef);
        URI uriVersion = this.translator.getNuxeoUrn(versionModel.getRepositoryName(), versionModel.getId());
        annotations = this.service.queryAnnotations(uriVersion, this.user);
        Assert.assertEquals((long)1L, (long)annotations.size());
        this.addAnnotationOn(url);
        annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)1L, (long)annotations.size());
        annotations = this.service.queryAnnotations(uriVersion, this.user);
        Assert.assertEquals((long)1L, (long)annotations.size());
        docModel = this.restoreToVersion(docModel.getRef(), versionRef);
        annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)1L, (long)annotations.size());
    }

    @Test
    public void testAnnotationsOnRestoreWithMultipleVersions() throws Exception {
        DocumentModel docModel = this.createDocument(this.session.getRootDocument().getPathAsString(), "fileAnnotationsOnRestoreWithMultipleVersions");
        String url = this.viewCodecManager.getUrlFromDocumentView((DocumentView)new DocumentViewImpl(docModel), true, SERVER);
        Assert.assertNotNull((Object)url);
        this.addAnnotationsOn(url, 3);
        URI uri = this.translator.getNuxeoUrn(docModel.getRepositoryName(), docModel.getId());
        List annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)3L, (long)annotations.size());
        DocumentRef version1ref = this.checkIn(docModel.getRef());
        List versions = this.session.getVersions(docModel.getRef());
        Assert.assertEquals((long)1L, (long)versions.size());
        DocumentModel versionModel1 = this.session.getDocument(version1ref);
        URI uriVersion1 = this.translator.getNuxeoUrn(versionModel1.getRepositoryName(), versionModel1.getId());
        annotations = this.service.queryAnnotations(uriVersion1, this.user);
        Assert.assertEquals((long)3L, (long)annotations.size());
        this.addAnnotationsOn(url, 3);
        annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)3L, (long)annotations.size());
        DocumentRef version2ref = this.checkIn(docModel.getRef());
        versions = this.session.getVersions(docModel.getRef());
        Assert.assertEquals((long)2L, (long)versions.size());
        DocumentModel versionModel2 = this.session.getDocument(version2ref);
        URI uriVersion2 = this.translator.getNuxeoUrn(versionModel2.getRepositoryName(), versionModel2.getId());
        annotations = this.service.queryAnnotations(uriVersion2, this.user);
        Assert.assertEquals((long)3L, (long)annotations.size());
        annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)0L, (long)annotations.size());
        annotations = this.service.queryAnnotations(uriVersion1, this.user);
        Assert.assertEquals((long)3L, (long)annotations.size());
        docModel = this.restoreToVersion(docModel.getRef(), version1ref);
        annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)3L, (long)annotations.size());
        docModel = this.restoreToVersion(docModel.getRef(), version2ref);
        annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)3L, (long)annotations.size());
    }

    @Test
    public void testDeleteAnnotationsOnVersions() throws Exception {
        DocumentModel docModel = this.createDocument(this.session.getRootDocument().getPathAsString(), "fileDeleteAnnotationsOnVersions");
        String url = this.viewCodecManager.getUrlFromDocumentView((DocumentView)new DocumentViewImpl(docModel), true, SERVER);
        Assert.assertNotNull((Object)url);
        this.addAnnotationsOn(url, 3);
        URI uri = this.translator.getNuxeoUrn(docModel.getRepositoryName(), docModel.getId());
        List annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)3L, (long)annotations.size());
        DocumentRef version1ref = this.checkIn(docModel.getRef());
        List versions = this.session.getVersions(docModel.getRef());
        Assert.assertEquals((long)1L, (long)versions.size());
        DocumentModel versionModel1 = this.session.getDocument(version1ref);
        URI uriVersion1 = this.translator.getNuxeoUrn(versionModel1.getRepositoryName(), versionModel1.getId());
        annotations = this.service.queryAnnotations(uriVersion1, this.user);
        Assert.assertEquals((long)3L, (long)annotations.size());
        this.addAnnotationsOn(url, 3);
        annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)3L, (long)annotations.size());
        DocumentRef version2ref = this.checkIn(docModel.getRef());
        versions = this.session.getVersions(docModel.getRef());
        Assert.assertEquals((long)2L, (long)versions.size());
        DocumentModel versionModel2 = this.session.getDocument(version2ref);
        URI uriVersion2 = this.translator.getNuxeoUrn(versionModel2.getRepositoryName(), versionModel2.getId());
        annotations = this.service.queryAnnotations(uriVersion2, this.user);
        Assert.assertEquals((long)3L, (long)annotations.size());
        DocumentModelList results = this.session.query("SELECT * FROM Document WHERE ecm:fulltext = 'zombie'", 10);
        Assert.assertEquals((long)0L, (long)results.size());
        Annotation annotationVersion1 = this.getAnnotation(uriVersion1.toASCIIString(), 1);
        annotationVersion1.setBodyText("zombie annotation");
        this.service.addAnnotation(annotationVersion1, this.user, uriVersion1.toASCIIString());
        this.session.save();
        this.nextTransaction();
        this.sleepForFulltext();
        results = this.session.query("SELECT * FROM Document WHERE ecm:fulltext = 'zombie'", 10);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)version1ref, (Object)((DocumentModel)results.get(0)).getRef());
        annotations = this.service.queryAnnotations(uriVersion1, this.user);
        for (Annotation annotation : annotations) {
            this.service.deleteAnnotationFor(uriVersion1, annotation, this.user);
        }
        annotations = this.service.queryAnnotations(uriVersion1, this.user);
        Assert.assertEquals((long)0L, (long)annotations.size());
        annotations = this.service.queryAnnotations(uriVersion2, this.user);
        for (Annotation annotation : annotations) {
            this.service.deleteAnnotationFor(uriVersion2, annotation, this.user);
        }
        annotations = this.service.queryAnnotations(uriVersion2, this.user);
        Assert.assertEquals((long)0L, (long)annotations.size());
        docModel = this.restoreToVersion(docModel.getRef(), version1ref);
        annotations = this.service.queryAnnotations(uri, this.user);
        Assert.assertEquals((long)0L, (long)annotations.size());
    }

    protected DocumentModel createDocument(String parentPath, String id) throws Exception {
        DocumentModel docModel = this.session.createDocumentModel(parentPath, id, "File");
        docModel = this.session.createDocument(docModel);
        this.session.save();
        return docModel;
    }

    protected Annotation addAnnotationOn(String url) throws Exception {
        Annotation annotation = this.getAnnotation(url, 1);
        return this.service.addAnnotation(annotation, this.user, SERVER);
    }

    protected void addAnnotationsOn(String url, int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            this.addAnnotationOn(url);
        }
    }

    protected DocumentRef checkIn(DocumentRef ref) throws Exception {
        this.session.save();
        DocumentRef v = this.session.checkIn(ref, null, null);
        this.session.checkOut(ref);
        this.session.save();
        this.nextTransaction();
        return v;
    }

    protected DocumentModel restoreToVersion(DocumentRef docRef, DocumentRef versionRef) throws Exception {
        this.session.save();
        DocumentModel docModel = this.session.restoreToVersion(docRef, versionRef);
        this.session.save();
        this.nextTransaction();
        return docModel;
    }
}

