/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.io.IOException;
import java.util.function.Supplier;
import org.nuxeo.ecm.automation.client.AdapterFactory;
import org.nuxeo.ecm.automation.client.AdapterManager;
import org.nuxeo.ecm.automation.client.AutomationClient;
import org.nuxeo.ecm.automation.client.LoginCallback;
import org.nuxeo.ecm.automation.client.LoginInfo;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.TokenCallback;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.ConnectorHandler;
import org.nuxeo.ecm.automation.client.jaxrs.spi.DefaultSession;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshalling;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;
import org.nuxeo.ecm.automation.client.jaxrs.spi.RequestInterceptor;
import org.nuxeo.ecm.automation.client.jaxrs.spi.auth.BasicAuthInterceptor;
import org.nuxeo.ecm.automation.client.jaxrs.spi.auth.TokenAuthInterceptor;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.PojoMarshaller;
import org.nuxeo.ecm.automation.client.model.OperationRegistry;

public abstract class AbstractAutomationClient
implements AutomationClient {
    private static final Object SHARED_REGISTRY_SYNCHRONIZER = new Object();
    private static volatile OperationRegistry sharedRegistry;
    private static long sharedRegistryUpdateTimestamp;
    private static long sharedRegistryExpirationDelay;
    protected final AdapterManager adapterManager = new AdapterManager();
    protected String url;
    protected Supplier<String> urlSupplier;
    protected volatile OperationRegistry registry;
    protected RequestInterceptor requestInterceptor;

    protected AbstractAutomationClient(String url) {
        this.url = url.endsWith("/") ? url : url + "/";
    }

    protected AbstractAutomationClient(Supplier<String> urlSupplier) {
        this.urlSupplier = urlSupplier;
    }

    public RequestInterceptor getRequestInterceptor() {
        return this.requestInterceptor;
    }

    @Override
    public void setRequestInterceptor(RequestInterceptor interceptor) {
        this.requestInterceptor = interceptor;
    }

    @Override
    public String getBaseUrl() {
        return this.urlSupplier == null ? this.url : this.urlSupplier.get();
    }

    public void setBasicAuth(String username, String password) {
        this.setRequestInterceptor(new BasicAuthInterceptor(username, password));
    }

    protected OperationRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void registerAdapter(AdapterFactory<?> factory) {
        this.adapterManager.registerAdapter(factory);
    }

    @Override
    public <T> T getAdapter(Session session, Class<T> adapterType) {
        return this.adapterManager.getAdapter(session, adapterType);
    }

    protected OperationRegistry connect(Connector connector) throws IOException {
        Request req = new Request(0, this.getBaseUrl());
        req.put("Accept", "application/json+nxautomation");
        return (OperationRegistry)connector.execute(req);
    }

    @Override
    public synchronized void shutdown() {
        this.adapterManager.clear();
        this.url = null;
        this.urlSupplier = null;
        this.registry = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession() throws IOException {
        Connector connector = this.newConnector();
        if (this.requestInterceptor != null) {
            connector = new ConnectorHandler(connector, this.requestInterceptor);
        }
        if (this.registry == null) {
            if (System.currentTimeMillis() - sharedRegistryUpdateTimestamp < sharedRegistryExpirationDelay) {
                this.registry = sharedRegistry;
            } else {
                Object object = SHARED_REGISTRY_SYNCHRONIZER;
                synchronized (object) {
                    if (System.currentTimeMillis() - sharedRegistryUpdateTimestamp < sharedRegistryExpirationDelay) {
                        this.registry = sharedRegistry;
                    } else {
                        sharedRegistry = this.registry = this.connect(connector);
                        sharedRegistryUpdateTimestamp = System.currentTimeMillis();
                    }
                }
            }
        }
        return this.login(connector);
    }

    @Override
    public Session getSession(String username, String password) throws IOException {
        return this.getSession(new BasicAuthInterceptor(username, password));
    }

    @Override
    public Session getSession(String token) throws IOException {
        return this.getSession(new TokenAuthInterceptor(token));
    }

    protected Session getSession(RequestInterceptor interceptor) throws IOException {
        this.setRequestInterceptor(interceptor);
        return this.getSession();
    }

    @Override
    public Session getSession(TokenCallback cb) throws IOException {
        String token = cb.getLocalToken();
        if (token == null) {
            token = cb.getRemoteToken(cb.getTokenParams());
            cb.saveToken(token);
        }
        return this.getSession(token);
    }

    @Override
    public Session getSession(LoginCallback loginCb) {
        throw new UnsupportedOperationException();
    }

    protected Session login(Connector connector) throws IOException {
        Request request = new Request(1, this.getBaseUrl() + this.getRegistry().getPath("login"));
        request.put("Accept", "application/json");
        LoginInfo login = (LoginInfo)connector.execute(request);
        return this.createSession(connector, login);
    }

    protected Session createSession(Connector connector, LoginInfo login) {
        return new DefaultSession(this, connector, login == null ? LoginInfo.ANONYNMOUS : login);
    }

    public void asyncExec(Runnable runnable) {
        throw new UnsupportedOperationException("Async execution not supported");
    }

    protected abstract Connector newConnector();

    public void setSharedRegistryExpirationDelay(long delay) {
        sharedRegistryExpirationDelay = delay;
    }

    @Override
    public void registerPojoMarshaller(Class<?> clazz) {
        JsonMarshalling.addMarshaller(PojoMarshaller.forClass(clazz));
    }

    static {
        sharedRegistryUpdateTimestamp = 0L;
        sharedRegistryExpirationDelay = 60000L;
    }
}

