/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.jaxrs.spi.AbstractAutomationClient;

public abstract class AsyncAutomationClient
extends AbstractAutomationClient {
    private static final Log log = LogFactory.getLog(AsyncAutomationClient.class);
    protected ExecutorService async;
    protected long asyncAwaitTerminationTimeout = 2000L;

    protected static ExecutorService getExecutorService() {
        return Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread("AutomationAsyncExecutor");
            }
        });
    }

    public AsyncAutomationClient(String url) {
        this(url, AsyncAutomationClient.getExecutorService());
    }

    public AsyncAutomationClient(Supplier<String> urlSupplier) {
        this(urlSupplier, AsyncAutomationClient.getExecutorService());
    }

    public AsyncAutomationClient(String url, ExecutorService executor) {
        super(url);
        this.async = executor;
    }

    public AsyncAutomationClient(Supplier<String> urlSupplier, ExecutorService executor) {
        super(urlSupplier);
        this.async = executor;
    }

    public AsyncAutomationClient(String url, long asyncAwaitTerminationTimeout) {
        this(url);
        this.asyncAwaitTerminationTimeout = asyncAwaitTerminationTimeout;
    }

    public AsyncAutomationClient(String url, ExecutorService executor, long asyncAwaitTerminationTimeout) {
        this(url, executor);
        this.asyncAwaitTerminationTimeout = asyncAwaitTerminationTimeout;
    }

    @Override
    public void asyncExec(Runnable runnable) {
        this.async.execute(runnable);
    }

    @Override
    public synchronized void shutdown() {
        try {
            this.async.awaitTermination(this.asyncAwaitTerminationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        super.shutdown();
        this.async = null;
    }
}

