/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.client.AutomationClient;
import org.nuxeo.ecm.automation.client.LoginInfo;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JavaClient;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JavaOperationRequest;
import org.nuxeo.ecm.automation.client.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.model.OperationRegistry;

public abstract class JavaSession
implements Session {
    protected final JavaClient client;
    protected final LoginInfo login;
    protected final OperationRegistry registry;

    public JavaSession(JavaClient client, LoginInfo login, OperationRegistry registry) {
        this.client = client;
        this.login = login;
        this.registry = registry;
    }

    protected OperationRequest createOperationRequest(JavaSession session, OperationDocumentation op, Map<String, Object> ctx) {
        return new JavaOperationRequest(session, op, ctx);
    }

    @Override
    public AutomationClient getClient() {
        return this.client;
    }

    @Override
    public LoginInfo getLogin() {
        return this.login;
    }

    @Override
    public <T> T getAdapter(Class<T> type) {
        return this.client.getAdapter(this, type);
    }

    @Override
    public OperationRequest newRequest(String id) {
        return this.newRequest(id, new HashMap<String, Object>());
    }

    @Override
    public OperationRequest newRequest(String id, Map<String, Object> ctx) {
        OperationDocumentation op = this.getOperation(id);
        if (op == null) {
            throw new IllegalArgumentException("No such operation: " + id);
        }
        return this.createOperationRequest(this, op, ctx);
    }

    protected OperationRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public OperationDocumentation getOperation(String id) {
        return this.registry.getOperation(id);
    }

    @Override
    public Map<String, OperationDocumentation> getOperations() {
        return this.registry.getOperations();
    }

    @Override
    public void close() {
    }
}

