/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.ws.rs.core.Response;
import org.apache.http.Header;
import org.apache.http.protocol.HttpContext;
import org.nuxeo.ecm.automation.client.RemoteException;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshalling;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.ExceptionMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.util.IOUtils;
import org.nuxeo.ecm.automation.client.jaxrs.util.InputStreamDataSource;
import org.nuxeo.ecm.automation.client.jaxrs.util.MultipartInput;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.StringBlob;

public class Request
extends HashMap<String, String> {
    public static final int GET = 0;
    public static final int POST = 1;
    private static final long serialVersionUID = 1L;
    protected static Pattern RFC2231_ATTR_PATTERN = Pattern.compile(";?\\s*filename\\s*\\\\*.*\\*=([^']*)'([^']*)'\\s*([^;]+)\\s*", 2);
    protected static Pattern ATTR_PATTERN = Pattern.compile(";?\\s*filename\\s*=\\s*([^;]+)\\s*", 2);
    protected final int method;
    protected final String url;
    protected final boolean isMultiPart;
    protected Object entity;

    public Request(int method, String url) {
        this.method = method;
        this.url = url;
        this.isMultiPart = false;
    }

    public Request(int method, String url, MimeMultipart entity) {
        this.method = method;
        this.url = url;
        this.entity = entity;
        this.isMultiPart = true;
    }

    public Request(int method, String url, String entity) {
        this.method = method;
        this.url = url;
        this.entity = entity;
        this.isMultiPart = false;
    }

    public int getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Object getEntity() {
        return this.entity;
    }

    public final boolean isMultiPart() {
        return this.isMultiPart;
    }

    public MimeMultipart asMultiPartEntity() {
        return this.isMultiPart ? (MimeMultipart)this.entity : null;
    }

    public String asStringEntity() {
        return this.isMultiPart ? null : (String)this.entity;
    }

    public Object handleResult(int status, Header[] headers, InputStream stream, HttpContext ctx) throws RemoteException, IOException {
        String ctype = Request.getHeaderValue(headers, "Content-Type");
        if (status >= Response.Status.BAD_REQUEST.getStatusCode()) {
            this.handleException(status, ctype, stream);
        } else if (status == Response.Status.NO_CONTENT.getStatusCode() || stream == null) {
            if (ctype != null && ctype.toLowerCase().startsWith("application/nuxeo-empty-list")) {
                return new Blobs();
            }
            return null;
        }
        if (ctype == null) {
            if (status != Response.Status.OK.getStatusCode()) {
                throw new RemoteException(status, "ServerError", "Server Error", "");
            }
            return null;
        }
        String disp = Request.getHeaderValue(headers, "Content-Disposition");
        String lctype = ctype.toLowerCase();
        if (lctype.startsWith("application/json+nxautomation")) {
            return JsonMarshalling.readRegistry(IOUtils.read(stream));
        }
        if (lctype.startsWith("application/json")) {
            String body = IOUtils.read(stream);
            try {
                return JsonMarshalling.readEntity(body);
            }
            catch (IOException | RuntimeException e) {
                return Request.readStringBlob(ctype, Request.getFileName(disp), body);
            }
        }
        if (lctype.startsWith("multipart/mixed")) {
            return Request.readBlobs(ctype, stream);
        }
        return Request.readBlob(ctype, Request.getFileName(disp), stream);
    }

    public static MultipartInput buildMultipartInput(Object input, String content) throws IOException {
        MultipartInput mpinput = new MultipartInput();
        mpinput.setRequest(content);
        if (input instanceof Blob) {
            mpinput.setBlob((Blob)input);
        } else if (input instanceof Blobs) {
            mpinput.setBlobs((Blobs)input);
        } else {
            throw new IllegalArgumentException("Unsupported binary input object: " + input);
        }
        return mpinput;
    }

    protected static Blobs readBlobs(String ctype, InputStream in) throws IOException {
        Blobs files = new Blobs();
        File file = IOUtils.copyToTempFile(in);
        try (FileInputStream fin = new FileInputStream(file);){
            MimeMultipart mp = new MimeMultipart((DataSource)new InputStreamDataSource(fin, ctype));
            int size = mp.getCount();
            for (int i = 0; i < size; ++i) {
                BodyPart part = mp.getBodyPart(i);
                String fname = part.getFileName();
                files.add(Request.readBlob(part.getContentType(), fname, part.getInputStream()));
            }
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
        finally {
            file.delete();
        }
        return files;
    }

    protected static Blob readBlob(String ctype, String fileName, InputStream in) throws IOException {
        File file = IOUtils.copyToTempFile(in);
        FileBlob blob = new FileBlob(file);
        blob.setMimeType(ctype);
        if (fileName != null) {
            blob.setFileName(fileName);
        }
        return blob;
    }

    protected static Blob readStringBlob(String ctype, String fileName, String content) {
        return new StringBlob(fileName, content, ctype);
    }

    protected static String getFileName(String ctype) {
        if (ctype == null) {
            return null;
        }
        Matcher m = RFC2231_ATTR_PATTERN.matcher(ctype);
        if (m.find()) {
            try {
                return URLDecoder.decode(m.group(3), m.group(1));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        m = ATTR_PATTERN.matcher(ctype);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    protected void handleException(int status, String ctype, InputStream stream) throws RemoteException {
        String content;
        if (stream == null) {
            throw new RemoteException(status, "ServerError", "Server Error", "");
        }
        try {
            content = IOUtils.read(stream);
        }
        catch (IOException e) {
            throw new RemoteException(status, "ServerError", "Server Error", "");
        }
        if ("application/json".equalsIgnoreCase(ctype)) {
            try {
                throw ExceptionMarshaller.readException(content);
            }
            catch (IOException t) {
                throw new RemoteException(status, "ServerError", "Server Error", content);
            }
        }
        throw new RemoteException(status, "ServerError", "Server Error", content);
    }

    public static String getHeaderValue(Header[] headers, String name) {
        for (Header header : headers) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header.getValue();
        }
        return null;
    }
}

