/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshaller;

public class NumberMarshaller
implements JsonMarshaller<Number> {
    @Override
    public String getType() {
        return "number";
    }

    @Override
    public Class<Number> getJavaType() {
        return Number.class;
    }

    @Override
    public Number read(JsonParser jp) throws IOException {
        jp.nextToken();
        jp.nextToken();
        return (Number)jp.readValueAs(Number.class);
    }

    @Override
    public void write(JsonGenerator jg, Object value) throws IOException {
        Number number = (Number)value;
        if (number instanceof Double || number instanceof Float) {
            jg.writeNumber(number.doubleValue());
        } else {
            jg.writeNumber(number.longValue());
        }
    }
}

