/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.StreamBlob;

public abstract class Blob
implements OperationInput {
    private static final long serialVersionUID = 1L;
    protected String mimeType;
    protected String fileName;

    public static Blob fromBase64String(String fileName, String content) {
        return Blob.fromBase64String(fileName, content, null);
    }

    public static Blob fromBase64String(String fileName, String content, String mimeType) {
        return new StreamBlob(new ByteArrayInputStream(Base64.decodeBase64((String)content)), fileName, mimeType);
    }

    protected Blob() {
    }

    public Blob(String fileName) {
        this(fileName, null);
    }

    public Blob(String fileName, String mimeType) {
        this.fileName = fileName;
        this.setMimeType(mimeType);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType == null ? "application/octet-stream" : mimeType;
    }

    public int getLength() {
        return -1;
    }

    @Override
    public String getInputType() {
        return "blob";
    }

    @Override
    public String getInputRef() {
        return null;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    public abstract InputStream getStream() throws IOException;

    protected String formatLength(int len) {
        int k = len / 1024;
        if (k <= 0) {
            return len + " B";
        }
        if (k < 1024) {
            return k + " K";
        }
        return k / 1024 + " M";
    }

    public String toString() {
        return this.fileName + " - " + this.mimeType + " - " + this.formatLength(this.getLength());
    }
}

