/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.model;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.automation.client.model.DateUtils;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class PropertyMapSetter {
    protected final Map<String, Object> map;
    protected final Set<String> dirties = new HashSet<String>();

    public PropertyMapSetter(PropertyMap propertyMap) {
        this.map = propertyMap.map;
    }

    public PropertyMap getDirties() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (String key : this.dirties) {
            Object value = this.map.get(key);
            resultMap.put(key, value);
        }
        return new PropertyMap(resultMap);
    }

    public void set(String key, String value) {
        if (value == null) {
            this.map.remove(key);
        }
        this.map.put(key, value);
        this.dirties.add(key);
    }

    public void set(String key, Boolean value) {
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value.toString());
        }
        this.dirties.add(key);
    }

    public void set(String key, Long value) {
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value.toString());
        }
        this.dirties.add(key);
    }

    public void set(String key, Double value) {
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value.toString());
        }
        this.dirties.add(key);
    }

    public void set(String key, Date value) {
        if (value == null) {
            this.map.remove(key);
        }
        this.map.put(key, DateUtils.formatDate(value));
        this.dirties.add(key);
    }

    public void set(String key, PropertyList value) {
        if (value == null) {
            this.map.remove(key);
        }
        this.map.put(key, value);
        this.dirties.add(key);
    }

    public void set(String key, PropertyMap value) {
        if (value == null) {
            this.map.remove(key);
        }
        this.map.put(key, value);
        this.dirties.add(key);
    }
}

