/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.adapters;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.Header;
import org.apache.http.protocol.HttpContext;
import org.nuxeo.ecm.automation.client.AutomationClient;
import org.nuxeo.ecm.automation.client.LoginInfo;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.RemoteException;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.DefaultOperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.spi.DefaultSession;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshalling;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;
import org.nuxeo.ecm.automation.client.jaxrs.util.MultipartInput;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.model.OperationInput;

public class AsyncSession
implements Session {
    protected static ExecutorService executor = Executors.newSingleThreadExecutor();
    protected final DefaultSession session;

    public AsyncSession(DefaultSession session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public AutomationClient getClient() {
        return this.session.getClient();
    }

    @Override
    public LoginInfo getLogin() {
        return this.session.getLogin();
    }

    @Override
    public OperationRequest newRequest(String id) {
        return this.newRequest(id, new HashMap<String, Object>());
    }

    @Override
    public OperationRequest newRequest(String id, Map<String, Object> ctx) {
        OperationDocumentation op = this.getOperation(id);
        if (op == null) {
            throw new IllegalArgumentException("No such operation: " + id);
        }
        return new DefaultOperationRequest(this, op, ctx);
    }

    @Override
    public Object execute(OperationRequest request) throws IOException {
        String ctype;
        AsyncRequest req;
        String content = JsonMarshalling.writeRequest(request);
        Object input = request.getInput();
        if (input instanceof OperationInput && ((OperationInput)input).isBinary()) {
            MultipartInput mpinput = Request.buildMultipartInput(input, content);
            req = new AsyncRequest(1, request.getUrl(), mpinput);
            ctype = mpinput.getContentType();
        } else {
            req = new AsyncRequest(1, request.getUrl(), content);
            ctype = "application/json";
        }
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            req.put((String)entry.getKey(), (String)entry.getValue());
        }
        req.put("Accept", "application/json, */*");
        req.put("Content-Type", ctype);
        if (req.get("X-NXDocumentProperties") == null && this.session.getDefaultSchemas() != null) {
            req.put("X-NXDocumentProperties", this.session.getDefaultSchemas());
        }
        try {
            return req.execute().get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RemoteException) {
                throw (RemoteException)e.getCause();
            }
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Blob getFile(String path) throws IOException {
        return this.session.getFile(path);
    }

    @Override
    public Blobs getFiles(String path) throws IOException {
        return this.session.getFiles(path);
    }

    @Override
    public OperationDocumentation getOperation(String id) {
        return this.session.getOperation(id);
    }

    @Override
    public Map<String, OperationDocumentation> getOperations() {
        return this.session.getOperations();
    }

    @Override
    public <T> T getAdapter(Class<T> type) {
        return this.session.getAdapter(type);
    }

    @Override
    public String getDefaultSchemas() {
        return this.session.getDefaultSchemas();
    }

    @Override
    public void setDefaultSchemas(String defaultSchemas) {
        this.session.setDefaultSchemas(defaultSchemas);
    }

    @Override
    public void close() {
        this.session.close();
    }

    public Connector getConnector() {
        return this.session.getConnector();
    }

    public class AsyncRequest
    extends CompletableRequest {
        private static final long serialVersionUID = 1L;
        protected static final String ASYNC_ADAPTER = "/@async";

        public AsyncRequest(int method, String url, String entity) {
            super(method, url + ASYNC_ADAPTER, entity);
        }

        public AsyncRequest(int method, String url, MultipartInput input) {
            super(method, url + ASYNC_ADAPTER, input);
        }

        @Override
        protected AsyncSession getSession() {
            return AsyncSession.this;
        }

        public CompletableFuture<Object> execute() {
            return this.call().thenCompose(req -> {
                if (req.getStatus() == 202) {
                    String location = req.getHeader("Location");
                    return this.poll(location, Duration.ofSeconds(1L), Duration.ofSeconds(30L));
                }
                return CompletableFuture.completedFuture(req.getResult());
            });
        }

        protected CompletableFuture<Object> poll(String location, Duration delay, Duration duration) {
            CompletableFuture<Object> resultFuture = new CompletableFuture<Object>();
            long deadline = System.nanoTime() + duration.toNanos();
            CompletableRequest req = new CompletableRequest(0, location);
            Future<?> pollFuture = executor.submit(() -> {
                do {
                    ((CompletableFuture)req.call().thenAccept(res -> {
                        if (req.isRedirected()) {
                            resultFuture.complete(res.getResult());
                        }
                    })).exceptionally(ex -> {
                        resultFuture.completeExceptionally(ex.getCause());
                        return null;
                    });
                    try {
                        Thread.sleep(delay.toMillis());
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                } while (deadline > System.nanoTime());
            });
            resultFuture.whenComplete((result, thrown) -> pollFuture.cancel(true));
            return resultFuture;
        }
    }

    public class CompletableRequest
    extends Request {
        private static final long serialVersionUID = 1L;
        protected CompletableFuture<CompletableRequest> future;
        protected int status;
        protected Header[] headers;
        protected Object result;
        protected boolean redirected;

        public CompletableRequest(int method, String url) {
            super(method, url, (String)null);
        }

        public CompletableRequest(int method, String url, String entity) {
            super(method, url, entity);
        }

        public CompletableRequest(int method, String url, MultipartInput input) {
            super(method, url, input);
        }

        @Override
        public Object handleResult(int status, Header[] headers, InputStream stream, HttpContext ctx) throws RemoteException, IOException {
            this.status = status;
            this.headers = headers;
            List redirects = (List)ctx.getAttribute("http.protocol.redirect-locations");
            this.redirected = CollectionUtils.isNotEmpty((Collection)redirects);
            try {
                this.result = super.handleResult(status, headers, stream, ctx);
                this.future.complete(this);
            }
            catch (RemoteException e) {
                this.future.completeExceptionally(e);
            }
            return this.result;
        }

        protected AsyncSession getSession() {
            return AsyncSession.this;
        }

        protected String getHeader(String name) {
            return Request.getHeaderValue(this.headers, name);
        }

        public CompletableFuture<? extends CompletableRequest> call() {
            this.future = new CompletableFuture();
            try {
                this.getSession().getConnector().execute(this);
            }
            catch (IOException e) {
                this.future.completeExceptionally(e);
            }
            return this.future;
        }

        public int getStatus() {
            return this.status;
        }

        public Object getResult() {
            return this.result;
        }

        public boolean isRedirected() {
            return this.redirected;
        }
    }
}

