/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.impl;

import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.model.DocRef;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.Documents;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyMap;

public class DocumentService {
    public static final String FetchDocument = "Document.Fetch";
    public static final String CreateDocument = "Document.Create";
    public static final String GetDocumentChildren = "Document.GetChildren";
    public static final String AttachBlob = "Blob.Attach";
    protected Session session;

    public DocumentService(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public Document getDocument(String ref) throws Exception {
        return (Document)this.session.newRequest(FetchDocument).set("value", ref).execute();
    }

    public Document createDocument(Document parent, String type, String name) throws Exception {
        return this.createDocument(parent, type, name, null);
    }

    public Document createDocument(Document parent, String type, String name, PropertyMap properties) throws Exception {
        OperationRequest req = this.session.newRequest(CreateDocument).setInput(parent).set("type", type).set("name", name);
        if (properties != null && properties.size() > 0) {
            req.set("properties", properties);
        }
        return (Document)req.execute();
    }

    public Documents getChildren(Document doc) throws Exception {
        return (Documents)this.session.newRequest(GetDocumentChildren).setInput(doc).execute();
    }

    public Documents getChildren(DocRef docRef) throws Exception {
        return (Documents)this.session.newRequest(GetDocumentChildren).setInput(docRef).execute();
    }
}

