/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.http.entity.AbstractHttpEntity;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blob;
import org.nuxeo.ecm.automation.client.jaxrs.model.HasFile;
import org.nuxeo.ecm.automation.client.jaxrs.util.BlobDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartRequestEntity
extends AbstractHttpEntity {
    protected MimeMultipart mp;

    public MultipartRequestEntity() {
        this(new MimeMultipart("related"));
    }

    public MultipartRequestEntity(String subType) {
        this(new MimeMultipart(subType));
    }

    public MultipartRequestEntity(MimeMultipart mp) {
        this.mp = mp;
        this.setContentType(mp.getContentType() + "; type=\"" + "application/json+nxrequest" + "\"; start=\"request\"");
    }

    public void setRequest(String content) throws Exception {
        MimeBodyPart part = new MimeBodyPart();
        part.setText(content, "UTF-8");
        part.setContentID("request");
        part.setHeader("Content-Type", "application/json+nxrequest; charset=UTF-8");
        part.setHeader("Content-Transfer-Encoding", "8bit");
        part.setHeader("Content-Length", Integer.toString(content.length()));
        this.mp.addBodyPart((BodyPart)part);
    }

    public void setBlob(Blob blob) throws Exception {
        this.setBlob(blob, "input");
    }

    protected void setBlob(Blob blob, String id) throws Exception {
        MimeBodyPart part = new MimeBodyPart();
        if (blob instanceof HasFile) {
            part.attachFile(((HasFile)((Object)blob)).getFile());
        } else {
            part.setDataHandler(new DataHandler((DataSource)new BlobDataSource(blob)));
        }
        part.setHeader("Content-Type", blob.getMimeType());
        part.setHeader("Content-Transfer-Encoding", "binary");
        int length = blob.getLength();
        if (length > -1) {
            part.setHeader("Content-Length", Integer.toString(length));
        }
        part.setContentID(id);
        this.mp.addBodyPart((BodyPart)part);
    }

    public void setBlobs(List<Blob> blobs) throws Exception {
        int size = blobs.size();
        for (int i = 0; i < size; ++i) {
            this.setBlob(blobs.get(i), "input#" + i);
        }
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isStreaming() {
        return false;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        throw new UnsupportedOperationException("Not a streaming entity");
    }

    public void writeTo(OutputStream arg0) throws IOException {
        try {
            this.mp.writeTo(arg0);
        }
        catch (MessagingException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public long getContentLength() {
        return -1L;
    }
}

