/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.jaxrs.AdapterFactory;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.AutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.Constants;
import org.nuxeo.ecm.automation.client.jaxrs.LoginInfo;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.DefaultSession;
import org.nuxeo.ecm.automation.client.jaxrs.spi.OperationRegistry;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;
import org.nuxeo.ecm.automation.client.jaxrs.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAutomationClient
implements AutomationClient,
Constants {
    protected int state;
    protected String url;
    protected volatile OperationRegistry registry;
    protected Map<Class<?>, List<AdapterFactory<?>>> adapters = new HashMap();

    protected AbstractAutomationClient() {
    }

    @Override
    public String getBaseUrl() {
        return this.url;
    }

    public OperationRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void registerAdapter(AdapterFactory<?> factory) {
        Class<?> adapter = factory.getAdapterType();
        List<AdapterFactory<?>> factories = this.adapters.get(adapter);
        if (factories == null) {
            factories = new ArrayList();
            this.adapters.put(adapter, factories);
        }
        factories.add(factory);
    }

    @Override
    public <T> T getAdapter(Object objToAdapt, Class<T> adapterType) {
        Class<?> cls = objToAdapt.getClass();
        List<AdapterFactory<?>> factories = this.adapters.get(adapterType);
        if (factories != null) {
            for (AdapterFactory<?> f : factories) {
                if (!f.getAcceptType().isAssignableFrom(cls)) continue;
                return (T)f.getAdapter(objToAdapt);
            }
        }
        return null;
    }

    @Override
    public OperationDocumentation getOperation(String id) {
        if (this.registry == null) {
            throw new IllegalStateException("Client not connected");
        }
        return this.registry.getOperation(id);
    }

    @Override
    public Map<String, OperationDocumentation> getOperations() {
        if (this.registry == null) {
            throw new IllegalStateException("Client not connected");
        }
        return this.registry.getOperations();
    }

    @Override
    public synchronized void connect(String url) throws Exception {
        if (this.url != null) {
            throw new IllegalStateException("Already connected to " + url);
        }
        this.url = url.endsWith("/") ? url : url + "/";
        Request req = new Request(0, url);
        req.put("Accept", "application/json+nxautomation");
        this.registry = (OperationRegistry)this.newConnector().execute(req);
    }

    @Override
    public synchronized void connect(final String url, final AsyncCallback<AutomationClient> cb) {
        this.asyncExec(new Runnable(){

            public void run() {
                try {
                    AbstractAutomationClient.this.connect(url);
                    cb.onSuccess(AbstractAutomationClient.this);
                }
                catch (Throwable t) {
                    cb.onError(t);
                }
            }
        });
    }

    @Override
    public synchronized boolean isConnected() {
        return this.url != null;
    }

    @Override
    public synchronized void disconnect() {
        this.url = null;
        this.registry = null;
        this.adapters = null;
    }

    @Override
    public Session getSession(String username, String password) throws Exception {
        if (!this.isConnected()) {
            throw new IllegalStateException("Cannot create an user session since client is not connected");
        }
        if (username != null) {
            return this.login(username, password);
        }
        return this.createSession(this.newConnector(), LoginInfo.ANONYNMOUS);
    }

    @Override
    public void getSession(final String username, final String password, final AsyncCallback<Session> cb) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Cannot create an user session since client is not connected");
        }
        this.asyncExec(new Runnable(){

            public void run() {
                try {
                    cb.onSuccess(AbstractAutomationClient.this.getSession(username, password));
                }
                catch (Throwable t) {
                    cb.onError(t);
                }
            }
        });
    }

    public Session login(String username, String password) throws Exception {
        if (!this.isConnected()) {
            throw new IllegalStateException("Cannot login since client is not connected");
        }
        Request request = new Request(1, this.url + this.getRegistry().getPath("login"));
        String auth = "Basic " + Base64.encode(username + ":" + password);
        request.put("Authorization", auth);
        request.put("Accept", "application/json+nxentity");
        Connector connector = this.newConnector();
        connector.setBasicAuth(auth);
        LoginInfo login = (LoginInfo)connector.execute(request);
        return this.createSession(connector, login);
    }

    protected Session createSession(Connector connector, LoginInfo login) {
        return new DefaultSession(this, connector, login == null ? LoginInfo.ANONYNMOUS : login);
    }

    public void asyncExec(Runnable runnable) {
        throw new UnsupportedOperationException("Async execution not supported");
    }

    protected abstract Connector newConnector();
}

