/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.nuxeo.ecm.automation.client.jaxrs.spi.AbstractAutomationClient;

public abstract class AsyncAutomationClient
extends AbstractAutomationClient {
    protected ExecutorService async;

    public AsyncAutomationClient() {
        this(Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread("AutomationAsyncExecutor");
            }
        }));
    }

    public AsyncAutomationClient(ExecutorService executor) {
        this.async = executor;
    }

    public void asyncExec(Runnable runnable) {
        this.async.execute(runnable);
    }

    public synchronized void disconnect() {
        try {
            this.async.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.disconnect();
        this.async = null;
    }
}

