/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.model.DateUtils;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationInput;
import org.nuxeo.ecm.automation.client.jaxrs.spi.DefaultSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOperationRequest
implements OperationRequest {
    protected OperationDocumentation op;
    protected DefaultSession session;
    protected Map<String, String> params;
    protected Map<String, String> ctx;
    protected OperationInput input;
    protected Map<String, String> headers;

    public DefaultOperationRequest(DefaultSession session, OperationDocumentation op) {
        this(session, op, new HashMap<String, String>());
    }

    public DefaultOperationRequest(DefaultSession session, OperationDocumentation op, Map<String, String> ctx) {
        this.session = session;
        this.op = op;
        this.params = new HashMap<String, String>();
        this.headers = new HashMap<String, String>();
        this.ctx = ctx;
    }

    @Override
    public DefaultSession getSession() {
        return this.session;
    }

    protected final boolean acceptInput(String type) {
        int size = this.op.signature.length;
        for (int i = 0; i < size; i += 2) {
            if ("void".equals(this.op.signature[i])) {
                return true;
            }
            if (!type.equals(this.op.signature[i])) continue;
            return true;
        }
        return false;
    }

    protected final void checkInput(String type) {
        if (!this.acceptInput(type)) {
            throw new IllegalArgumentException("Input not supported: " + type);
        }
    }

    public List<String> getParamNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (OperationDocumentation.Param param : this.op.params) {
            result.add(param.name);
        }
        return result;
    }

    public OperationDocumentation.Param getParam(String key) {
        for (OperationDocumentation.Param param : this.op.params) {
            if (!key.equals(param.name)) continue;
            return param;
        }
        return null;
    }

    @Override
    public OperationRequest setInput(OperationInput input) {
        if (input == null) {
            this.checkInput("void");
        } else {
            this.checkInput(input.getInputType());
        }
        this.input = input;
        return this;
    }

    @Override
    public OperationInput getInput() {
        return this.input;
    }

    @Override
    public String getUrl() {
        return this.session.getClient().getBaseUrl() + this.op.url;
    }

    @Override
    public OperationRequest set(String key, Object value) {
        OperationDocumentation.Param param = this.getParam(key);
        if (param == null) {
            throw new IllegalArgumentException("No such parameter '" + key + "' for operation " + this.op.id + ".\n\tAvailable params: " + this.getParamNames());
        }
        if (value == null) {
            this.params.remove(key);
            return this;
        }
        if (value.getClass() == Date.class) {
            this.params.put(key, DateUtils.formatDate((Date)value));
        } else {
            this.params.put(key, value.toString());
        }
        return this;
    }

    @Override
    public OperationRequest setContextProperty(String key, String value) {
        this.ctx.put(key, value);
        return this;
    }

    @Override
    public Map<String, String> getContextParameters() {
        return this.ctx;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.params;
    }

    @Override
    public Object execute() throws Exception {
        return this.session.execute(this);
    }

    @Override
    public void execute(AsyncCallback<Object> cb) {
        this.session.execute(this, cb);
    }

    @Override
    public OperationRequest setHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

