/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.AutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.Constants;
import org.nuxeo.ecm.automation.client.jaxrs.LoginInfo;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blob;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blobs;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationInput;
import org.nuxeo.ecm.automation.client.jaxrs.spi.AbstractAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.DefaultOperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshalling;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;
import org.nuxeo.ecm.automation.client.jaxrs.util.MultipartInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSession
implements Session,
Constants {
    protected AbstractAutomationClient client;
    protected Connector connector;
    protected LoginInfo login;

    public DefaultSession(AbstractAutomationClient client, Connector connector, LoginInfo login) {
        this.client = client;
        this.connector = connector;
        this.login = login;
    }

    @Override
    public AutomationClient getClient() {
        return this.client;
    }

    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public LoginInfo getLogin() {
        return this.login;
    }

    @Override
    public <T> T getAdapter(Class<T> type) {
        return this.client.getAdapter(this, type);
    }

    @Override
    public Object execute(OperationRequest request) throws Exception {
        String ctype;
        Request req = null;
        String content = JsonMarshalling.writeRequest(request);
        OperationInput input = request.getInput();
        if (input != null && input.isBinary()) {
            MultipartInput mpinput = new MultipartInput();
            mpinput.setRequest(content);
            ctype = mpinput.getContentType();
            if (input instanceof Blob) {
                Blob blob = (Blob)input;
                mpinput.setBlob(blob);
            } else if (input instanceof Blobs) {
                mpinput.setBlobs((Blobs)input);
            } else {
                throw new IllegalArgumentException("Unsupported binary input object: " + input);
            }
            req = new Request(1, request.getUrl(), mpinput);
        } else {
            req = new Request(1, request.getUrl(), content);
            ctype = "application/json+nxrequest";
        }
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            req.put(entry.getKey(), entry.getValue());
        }
        req.put("Accept", "application/json+nxentity, */*");
        req.put("Content-Type", ctype);
        if (this.connector.getBasicAuth() != null) {
            req.put("Authorization", this.connector.getBasicAuth());
        }
        return this.connector.execute(req);
    }

    @Override
    public void execute(final OperationRequest request, final AsyncCallback<Object> cb) {
        this.client.asyncExec(new Runnable(){

            public void run() {
                try {
                    cb.onSuccess(DefaultSession.this.execute(request));
                }
                catch (Throwable t) {
                    cb.onError(t);
                }
            }
        });
    }

    @Override
    public Blob getFile(String path) throws Exception {
        Request req = new Request(0, this.client.getBaseUrl() + path);
        if (this.connector.getBasicAuth() != null) {
            req.put("Authorization", this.connector.getBasicAuth());
        }
        return (Blob)this.connector.execute(req);
    }

    @Override
    public Blobs getFiles(String path) throws Exception {
        Request req = new Request(0, this.client.getBaseUrl() + path);
        if (this.connector.getBasicAuth() != null) {
            req.put("Authorization", this.connector.getBasicAuth());
        }
        return (Blobs)this.connector.execute(req);
    }

    @Override
    public void getFile(final String path, final AsyncCallback<Blob> cb) throws Exception {
        this.client.asyncExec(new Runnable(){

            public void run() {
                try {
                    cb.onSuccess(DefaultSession.this.getFile(path));
                }
                catch (Throwable t) {
                    cb.onError(t);
                }
            }
        });
    }

    @Override
    public void getFiles(final String path, final AsyncCallback<Blobs> cb) throws Exception {
        this.client.asyncExec(new Runnable(){

            public void run() {
                try {
                    cb.onSuccess(DefaultSession.this.getFiles(path));
                }
                catch (Throwable t) {
                    cb.onError(t);
                }
            }
        });
    }

    @Override
    public OperationRequest newRequest(String id) throws Exception {
        return this.newRequest(id, new HashMap<String, String>());
    }

    @Override
    public OperationRequest newRequest(String id, Map<String, String> ctx) throws Exception {
        OperationDocumentation op = this.getOperation(id);
        if (op == null) {
            throw new IllegalArgumentException("No such operation: " + id);
        }
        DefaultOperationRequest req = new DefaultOperationRequest(this, op, ctx);
        return req;
    }

    @Override
    public OperationDocumentation getOperation(String id) {
        return this.client.getOperation(id);
    }

    @Override
    public Map<String, OperationDocumentation> getOperations() {
        return this.client.getOperations();
    }
}

