/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.model;

import java.util.Date;
import org.nuxeo.ecm.automation.client.jaxrs.model.DocRef;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyMap;

public class Document
extends DocRef {
    protected final String path;
    protected final String type;
    protected final String state;
    protected final String lock;
    protected final PropertyMap properties;

    public Document(String id, String type, String path, String state, String lock, PropertyMap properties) {
        super(id);
        this.path = path;
        this.type = type;
        this.state = state;
        this.lock = lock;
        this.properties = properties == null ? new PropertyMap() : properties;
    }

    public String getId() {
        return this.ref;
    }

    @Override
    public String getInputType() {
        return "document";
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public String getLock() {
        return this.lock;
    }

    public String getState() {
        return this.state;
    }

    public Date getLastModified() {
        return this.properties.getDate("dc:modified");
    }

    public String getTitle() {
        return this.properties.getString("dc:title");
    }

    public PropertyMap getProperties() {
        return this.properties;
    }

    public String getString(String key) {
        return this.properties.getString(key);
    }

    public Date getDate(String key) {
        return this.properties.getDate(key);
    }

    public Long getLong(String key) {
        return this.properties.getLong(key);
    }

    public Double getDouble(String key) {
        return this.properties.getDouble(key);
    }

    public String getString(String key, String defValue) {
        return this.properties.getString(key, defValue);
    }

    public Date getDate(String key, Date defValue) {
        return this.properties.getDate(key, defValue);
    }

    public Long getLong(String key, Long defValue) {
        return this.properties.getLong(key, defValue);
    }

    public Double getDouble(String key, Double defValue) {
        return this.properties.getDouble(key, defValue);
    }

    public void set(String key, String defValue) {
        this.properties.set(key, defValue);
    }

    public void set(String key, Date defValue) {
        this.properties.set(key, defValue);
    }

    public void set(String key, Long defValue) {
        this.properties.set(key, defValue);
    }

    public void set(String key, Double defValue) {
        this.properties.set(key, defValue);
    }
}

